/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.swarm;

import com.hazelcast.config.Config;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.Join;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.swarm.MapSwarmNodesManager;
import org.pepstock.jem.gwt.server.swarm.OutputQueueManager;
import org.pepstock.jem.gwt.server.swarm.RoutingQueueManager;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.gwt.server.swarm.listeners.NodeListener;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.ExecutionEnvironment;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class MainSwarm {
    private SwarmConfiguration activeConfiguration = null;
    private HazelcastInstance swarmInstance = null;
    private RoutingQueueManager routingQueueManager = null;
    private OutputQueueManager outputQueueManager = null;
    private MapSwarmNodesManager mapSwarmNodesManager = null;
    private NodeInfo nodeInfo = new NodeInfo();
    private Status status = Status.DRAINED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwarmConfiguration getActiveConfiguration() {
        IMap routingConfigMap = SharedObjects.getInstance().getLocalMember().getMap("org.pepstock.jem.routingConfig");
        if (!routingConfigMap.containsKey((Object)"ROUTING_CONFIGURATION")) {
            this.activeConfiguration = new SwarmConfiguration();
            try {
                routingConfigMap.lock((Object)"ROUTING_CONFIGURATION");
                routingConfigMap.put((Object)"ROUTING_CONFIGURATION", (Object)this.activeConfiguration);
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO015E, (Throwable)e);
            }
            finally {
                routingConfigMap.unlock((Object)"ROUTING_CONFIGURATION");
            }
        } else {
            try {
                routingConfigMap.lock((Object)"ROUTING_CONFIGURATION");
                this.activeConfiguration = (SwarmConfiguration)routingConfigMap.get((Object)"ROUTING_CONFIGURATION");
            }
            catch (Exception e) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO015E, (Throwable)e);
            }
            finally {
                routingConfigMap.unlock((Object)"ROUTING_CONFIGURATION");
            }
        }
        return this.activeConfiguration;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.swarmInstance;
    }

    public RoutingQueueManager getRoutingQueueManager() {
        return this.routingQueueManager;
    }

    public void start() throws Exception {
        if (this.getStatus().equals((Object)Status.DRAINED)) {
            this.setStatus(Status.STARTING);
            this.getActiveConfiguration();
            if (this.activeConfiguration.isEnabled()) {
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO001I);
                try {
                    this.startUpHazelcast();
                }
                catch (Exception e) {
                    this.setStatus(Status.DRAINED);
                    throw e;
                }
                Cluster cluster = this.swarmInstance.getCluster();
                Member member = cluster.getLocalMember();
                this.initNodeInfo(member);
                this.setStatus(Status.ACTIVE);
                this.routingQueueManager = new RoutingQueueManager();
                this.outputQueueManager = new OutputQueueManager();
                this.mapSwarmNodesManager = new MapSwarmNodesManager();
                this.registerNode();
            } else {
                this.setStatus(Status.DRAINED);
                LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO002I);
            }
        }
    }

    public void shutDown() {
        if (this.getStatus().equals((Object)Status.ACTIVE)) {
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO003I);
            this.setStatus(Status.SHUTTING_DOWN);
            while (!this.getRoutingQueueManager().isRouteEnded() || !this.getOutputQueueManager().isNotifyOutputEnded()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO015E, (Throwable)e);
                }
            }
            this.swarmInstance.getLifecycleService().shutdown();
            this.swarmInstance = null;
            LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO004I);
            this.setStatus(Status.DRAINED);
        }
    }

    private void startUpHazelcast() throws Exception {
        Config cfg = new Config();
        cfg.getGroupConfig().setName(this.activeConfiguration.getGroupName());
        cfg.getGroupConfig().setPassword(this.activeConfiguration.getGroupPassword());
        NetworkConfig network = cfg.getNetworkConfig();
        network.setPort(this.activeConfiguration.getPort());
        network.setPortAutoIncrement(true);
        if (this.activeConfiguration.getNetworkInterface() != null) {
            network.getInterfaces().setEnabled(true).addInterface(this.activeConfiguration.getNetworkInterface());
        }
        Join join = network.getJoin();
        join.getTcpIpConfig().setEnabled(true);
        join.getMulticastConfig().setEnabled(false);
        if (this.activeConfiguration.getNetworks().size() == 0) {
            throw new Exception(SwarmNodeMessage.JEMO020E.toMessage().getMessage());
        }
        for (String tcpNode : this.activeConfiguration.getNetworks()) {
            join.getTcpIpConfig().addMember(tcpNode);
        }
        cfg.getPartitionGroupConfig().setEnabled(true);
        cfg.getPartitionGroupConfig().setGroupType(PartitionGroupConfig.MemberGroupType.HOST_AWARE);
        cfg.getProperties().setProperty("hazelcast.logging.type", "log4j");
        ExecutorConfig executor = new ExecutorConfig("pool", 16, 64, 60);
        cfg.addExecutorConfig(executor);
        this.swarmInstance = Hazelcast.newHazelcastInstance((Config)cfg);
        this.swarmInstance.getCluster().addMembershipListener((MembershipListener)new NodeListener());
    }

    private void registerNode() {
        IMap map = this.swarmInstance.getMap("org.pepstock.jem.swarm.nodes");
        map.put((Object)this.nodeInfo.getKey(), (Object)this.nodeInfo);
    }

    private void initNodeInfo(Member member) {
        this.nodeInfo.setKey(member.getUuid());
        InetSocketAddress address = member.getInetSocketAddress();
        this.nodeInfo.setPort(address.getPort());
        this.nodeInfo.setIpaddress(address.getAddress().getHostAddress());
        this.nodeInfo.setLabel(this.nodeInfo.getIpaddress() + ":" + this.nodeInfo.getPort());
        this.nodeInfo.setProcessId(ManagementFactory.getRuntimeMXBean().getName());
        String hostname = StringUtils.substringAfter((String)this.nodeInfo.getProcessId(), (String)"@");
        this.nodeInfo.setHostname(hostname);
        OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
        this.nodeInfo.getNodeInfoBean().setSystemArchitecture(bean.getArch());
        this.nodeInfo.getNodeInfoBean().setAvailableProcessors(bean.getAvailableProcessors());
        this.nodeInfo.getNodeInfoBean().setSystemName(bean.getName());
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironment();
        executionEnvironment.setEnvironment(SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName());
        this.nodeInfo.setExecutionEnvironment(executionEnvironment);
        this.nodeInfo.setJemVersion(SharedObjects.getInstance().getJemVersion());
    }

    public NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    public MapSwarmNodesManager getMapSwarmNodesManager() {
        return this.mapSwarmNodesManager;
    }

    public OutputQueueManager getOutputQueueManager() {
        return this.outputQueueManager;
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status status) {
        this.status = status;
        this.nodeInfo.setStatus(status);
        if (this.swarmInstance != null && this.swarmInstance.getLifecycleService().isRunning()) {
            IMap members_map = this.swarmInstance.getMap("org.pepstock.jem.swarm.nodes");
            String key = this.nodeInfo.getKey();
            if (key != null && members_map.containsKey((Object)key)) {
                try {
                    members_map.lock((Object)key);
                    NodeInfo info = (NodeInfo)members_map.get((Object)key);
                    info.setStatus(status);
                    members_map.replace((Object)info.getKey(), (Object)info);
                }
                catch (Exception ex) {
                    LogAppl.getInstance().emit((MessageInterface)SwarmNodeMessage.JEMO016E, (Throwable)ex);
                }
                finally {
                    members_map.unlock((Object)key);
                }
            }
        }
    }
}

