/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.LoginManager;
import org.pepstock.jem.gwt.server.servlet.JemDefaultServlet;

public class Login
extends JemDefaultServlet {
    private static final long serialVersionUID = 1L;
    private transient LoginManager loginManager = null;

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.execute(request, response);
        if (this.loginManager == null) {
            try {
                this.loginManager = new LoginManager();
            }
            catch (Exception e) {
                throw new ServletException(e.getMessage());
            }
        }
        Properties properties = new Properties();
        properties.load((InputStream)request.getInputStream());
        String user = properties.getProperty("jem.command.user");
        String password = properties.getProperty("jem.command.password");
        if (user == null) {
            throw new ServletException(UserInterfaceMessage.JEMG023E.toMessage().getFormattedMessage(new Object[]{"user"}));
        }
        if (password == null) {
            throw new ServletException(UserInterfaceMessage.JEMG023E.toMessage().getFormattedMessage(new Object[]{"password"}));
        }
        try {
            this.loginManager.login(user, password);
        }
        catch (Exception ex) {
            throw new ServletException(ex.getMessage());
        }
        response.setContentType("text/plain");
        response.getWriter().print("User " + user + " logged in successfully!");
        response.getWriter().close();
    }
}

