/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.servlet;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pepstock.jem.console.commands.resources.Get;
import org.pepstock.jem.console.commands.resources.GetList;
import org.pepstock.jem.console.commands.resources.Remove;
import org.pepstock.jem.console.commands.resources.Set;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CommonResourcesManager;
import org.pepstock.jem.gwt.server.servlet.JemDefaultServlet;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.Resources;

public class CommonResources
extends JemDefaultServlet {
    private static final long serialVersionUID = 1L;
    private transient CommonResourcesManager manager = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.execute(request, response);
        if (this.manager == null) {
            this.manager = new CommonResourcesManager();
        }
        Boolean returnedObject = null;
        XStream streamer = new XStream();
        String action = request.getParameter("action");
        try {
            if (action.equalsIgnoreCase(Set.class.getName())) {
                Object object = streamer.fromXML((Reader)request.getReader());
                if (object instanceof Resource) {
                    Resource resource = (Resource)object;
                    boolean isAdded = this.manager.put(resource);
                    returnedObject = isAdded;
                } else {
                    if (!(object instanceof Resources)) throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage(new Object[]{"set", object.getClass().getName()}));
                    Resources resources = (Resources)object;
                    boolean isAdded = true;
                    for (Resource resource : resources.getResources()) {
                        boolean added = this.manager.put(resource);
                        isAdded = isAdded && added;
                    }
                    returnedObject = isAdded;
                }
            } else if (action.equalsIgnoreCase(Get.class.getName())) {
                Object object = streamer.fromXML((Reader)request.getReader());
                if (!(object instanceof String)) throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage(new Object[]{"get", object.getClass().getName()}));
                String name = object.toString();
                Resource resource = this.manager.get(name);
                returnedObject = resource;
            } else if (action.equalsIgnoreCase(Remove.class.getName())) {
                Object object = streamer.fromXML((Reader)request.getReader());
                if (!(object instanceof String)) throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage(new Object[]{"remove", object.getClass().getName()}));
                String name = object.toString();
                boolean isRemoved = this.manager.remove(name);
                returnedObject = isRemoved;
            } else if (action.equalsIgnoreCase(GetList.class.getName())) {
                Object object = streamer.fromXML((Reader)request.getReader());
                if (!(object instanceof String)) throw new ServletException(UserInterfaceMessage.JEMG028E.toMessage().getFormattedMessage(new Object[]{"get", object.getClass().getName()}));
                String name = object.toString();
                ArrayList<Resource> resourcesCollection = new ArrayList<Resource>(this.manager.values(name));
                Resources resources = new Resources();
                resources.setResources(resourcesCollection);
                returnedObject = resources;
            }
            response.setContentType("text/xml");
            response.getWriter().print(streamer.toXML((Object)returnedObject));
            response.getWriter().close();
            return;
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }
}

