/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.gwt.server.services.NodesManager;
import org.pepstock.jem.gwt.server.swarm.SwarmNodeMessage;
import org.pepstock.jem.gwt.server.swarm.executors.Drain;
import org.pepstock.jem.gwt.server.swarm.executors.GetStatus;
import org.pepstock.jem.gwt.server.swarm.executors.Start;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.configuration.SwarmConfiguration;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;
import org.pepstock.jem.util.filters.predicates.NodePredicate;

public class SwarmNodesManager
extends DefaultService {
    private NodesManager nodeManager = new NodesManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeInfoBean> getNodes(String nodesFilter) throws Exception {
        ArrayList<NodeInfoBean> list = new ArrayList<NodeInfoBean>();
        HazelcastInstance swarmHazelcast = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance();
        if (swarmHazelcast == null || !swarmHazelcast.getLifecycleService().isRunning()) {
            return list;
        }
        String permission = "search:nodes:" + nodesFilter.toLowerCase();
        this.checkAuthorization((Permission)new StringPermission(permission));
        String sqlFilter = nodesFilter.replace('.', '_');
        sqlFilter = sqlFilter.replace('*', '%');
        IMap nodes = swarmHazelcast.getMap("org.pepstock.jem.swarm.nodes");
        StringBuffer sb = new StringBuffer();
        sb.append("(hostname like '").append(sqlFilter).append("'").append(" OR ");
        sb.append("label like '").append(sqlFilter).append("') ").append(" AND ");
        sb.append("isSuperNode = false");
        SqlPredicate predicate = new SqlPredicate(sb.toString());
        Collection allNodes = null;
        if (nodes.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                allNodes = nodes.values((Predicate)predicate);
            }
            finally {
                nodes.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.swarm.nodes"}));
        }
        if (allNodes != null) {
            for (NodeInfo node : allNodes) {
                list.add(node.getNodeInfoBean());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeInfoBean> getNodesByFilter(String nodesFilter) throws Exception {
        ArrayList<NodeInfoBean> list = new ArrayList<NodeInfoBean>();
        HazelcastInstance swarmHazelcast = SharedObjects.getInstance().getMainSwarm().getHazelcastInstance();
        if (swarmHazelcast == null || !swarmHazelcast.getLifecycleService().isRunning()) {
            return list;
        }
        Filter filter = null;
        try {
            filter = Filter.parse((String)nodesFilter);
        }
        catch (Exception e) {
            filter = new Filter();
            filter.add(new FilterToken(NodeFilterFields.NAME.getName(), ""));
        }
        String nodesPermString = filter.get(NodeFilterFields.NAME.getName());
        if (!(nodesPermString != null && nodesPermString.trim().length() != 0 || (nodesPermString = filter.get(NodeFilterFields.HOSTNAME.getName())) != null && nodesPermString.trim().length() != 0)) {
            nodesPermString = "*";
        }
        String permission = "search:nodes:" + nodesPermString.toLowerCase();
        this.checkAuthorization((Permission)new StringPermission(permission));
        IMap nodes = swarmHazelcast.getMap("org.pepstock.jem.swarm.nodes");
        NodePredicate predicate = new NodePredicate(filter);
        Collection allNodes = null;
        if (nodes.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                allNodes = nodes.values((Predicate)predicate);
            }
            finally {
                nodes.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.swarm.nodes"}));
        }
        if (allNodes != null) {
            for (NodeInfo node : allNodes) {
                if (node.getStatus().equals((Object)Status.DRAINED)) continue;
                list.add(node.getNodeInfoBean());
            }
        }
        return list;
    }

    public Boolean start() throws Exception {
        this.checkAuthorization((Permission)new StringPermission("swarm-nodes:start"));
        SwarmConfiguration conf = SharedObjects.getInstance().getMainSwarm().getActiveConfiguration();
        if (!conf.isEnabled()) {
            throw new Exception(SwarmNodeMessage.JEMO019E.toMessage().getFormattedMessage(new Object[0]));
        }
        Boolean result = Boolean.TRUE;
        Collection<NodeInfoBean> webNodes = this.nodeManager.getWebNodes("*");
        for (NodeInfoBean node : webNodes) {
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Start(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                executorService.execute((Runnable)task);
                try {
                    Status status = (Status)task.get();
                    if (status.equals((Object)Status.ACTIVE)) continue;
                    result = Boolean.FALSE;
                }
                catch (InterruptedException e) {
                    throw new Exception(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public Boolean drain() throws Exception {
        this.checkAuthorization((Permission)new StringPermission("swarm-nodes:drain"));
        Boolean result = Boolean.TRUE;
        Collection<NodeInfoBean> webNodes = this.nodeManager.getWebNodes("*");
        for (NodeInfoBean node : webNodes) {
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Drain(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                executorService.execute((Runnable)task);
                try {
                    Status status = (Status)task.get();
                    if (status.equals((Object)Status.DRAINED)) continue;
                    result = Boolean.FALSE;
                }
                catch (InterruptedException e) {
                    throw new Exception(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public String getStatus() throws Exception {
        this.checkAuthentication();
        Status currentStatus = null;
        Collection<NodeInfoBean> webNodes = this.nodeManager.getWebNodes("*");
        for (NodeInfoBean node : webNodes) {
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new GetStatus(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                executorService.execute((Runnable)task);
                try {
                    Status status = (Status)task.get();
                    if (currentStatus == null) {
                        currentStatus = status;
                        continue;
                    }
                    if (currentStatus.equals((Object)status)) continue;
                    return Status.UNKNOWN.getDescription();
                }
                catch (InterruptedException e) {
                    throw new Exception(e.getMessage(), e);
                }
                catch (ExecutionException e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        }
        return currentStatus == null ? Status.UNKNOWN.getDescription() : currentStatus.getDescription();
    }
}

