/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.IMap;
import java.util.Date;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.configuration.SwarmConfiguration;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;

public class RoutingConfigManager
extends DefaultService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwarmConfiguration getSwarmConfiguration(String name) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("swarm-nodes:viewconfig"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.routingConfig");
        if (map.containsKey((Object)name)) {
            try {
                map.lock((Object)name);
                SwarmConfiguration swarmConfiguration = (SwarmConfiguration)map.get((Object)name);
                return swarmConfiguration;
            }
            finally {
                map.unlock((Object)name);
            }
        }
        throw new Exception(UserInterfaceMessage.JEMG044E.toMessage().getFormattedMessage(new Object[]{name}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwarmConfiguration updateSwarmConfiguration(SwarmConfiguration conf) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("swarm-nodes:editconfig"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.routingConfig");
        if (map.containsKey((Object)conf.getName())) {
            try {
                map.lock((Object)conf.getName());
                SwarmConfiguration oldConf = (SwarmConfiguration)map.get((Object)conf.getName());
                if (oldConf.getUser() != null && !oldConf.getUser().equalsIgnoreCase(conf.getUser())) {
                    LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldConf, conf});
                    throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldConf, conf}));
                }
                if (oldConf.getLastModified() != null && !oldConf.getLastModified().equals(conf.getLastModified())) {
                    LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldConf, conf});
                    throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldConf, conf}));
                }
                Subject currentUser = SecurityUtils.getSubject();
                User userPrincipal = (User)currentUser.getPrincipal();
                String userId = userPrincipal.getId();
                conf.setUser(userId);
                conf.setLastModified(new Date());
                map.put((Object)conf.getName(), (Object)conf);
                SwarmConfiguration swarmConfiguration = conf;
                return swarmConfiguration;
            }
            finally {
                map.unlock((Object)conf.getName());
            }
        }
        throw new Exception(UserInterfaceMessage.JEMG044E.toMessage().getFormattedMessage(new Object[]{conf.getName()}));
    }
}

