/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.node.ConfigurationFile;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.Status;
import org.pepstock.jem.node.affinity.Result;
import org.pepstock.jem.node.executors.GenericCallBack;
import org.pepstock.jem.node.executors.affinity.CheckAffinityPolicy;
import org.pepstock.jem.node.executors.affinity.GetAffinityPolicy;
import org.pepstock.jem.node.executors.affinity.SaveAffinityPolicy;
import org.pepstock.jem.node.executors.configuration.CheckHazelcastConfiguration;
import org.pepstock.jem.node.executors.configuration.CheckJemConfiguration;
import org.pepstock.jem.node.executors.configuration.CheckJemEnvConfiguration;
import org.pepstock.jem.node.executors.configuration.GetHazelcastConfiguration;
import org.pepstock.jem.node.executors.configuration.GetJemConfiguration;
import org.pepstock.jem.node.executors.configuration.GetJemEnvConfiguration;
import org.pepstock.jem.node.executors.configuration.SaveHazelcastConfiguration;
import org.pepstock.jem.node.executors.configuration.SaveJemConfiguration;
import org.pepstock.jem.node.executors.configuration.SaveJemEnvConfiguration;
import org.pepstock.jem.node.executors.nodes.Drain;
import org.pepstock.jem.node.executors.nodes.GetLog;
import org.pepstock.jem.node.executors.nodes.Shutdown;
import org.pepstock.jem.node.executors.nodes.Start;
import org.pepstock.jem.node.executors.nodes.Top;
import org.pepstock.jem.node.executors.nodes.Update;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.NodeFilterFields;
import org.pepstock.jem.util.filters.predicates.NodePredicate;

public class NodesManager
extends DefaultService {
    public Collection<NodeInfoBean> getNodes(String nodesFilter) throws Exception {
        return this.getNodes(nodesFilter, false);
    }

    public Collection<NodeInfoBean> getWebNodes(String nodesFilter) throws Exception {
        return this.getNodes(nodesFilter, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeInfoBean> getNodes(String nodesFilter, boolean webNodes) throws Exception {
        String permission = "search:nodes:" + nodesFilter.toLowerCase();
        this.checkAuthorization((Permission)new StringPermission(permission));
        String sqlFilter = nodesFilter.replace('.', '_');
        sqlFilter = sqlFilter.replace('*', '%');
        IMap nodes = this.getInstance().getMap("org.pepstock.jem.nodes");
        StringBuffer sb = new StringBuffer();
        sb.append("(hostname like '").append(sqlFilter).append("'").append(" OR ");
        sb.append("label like '").append(sqlFilter).append("') ").append(" AND ");
        sb.append("isSuperNode = " + webNodes);
        SqlPredicate predicate = new SqlPredicate(sb.toString());
        ArrayList<NodeInfoBean> list = new ArrayList<NodeInfoBean>();
        Collection allNodes = null;
        if (nodes.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                allNodes = nodes.values((Predicate)predicate);
            }
            finally {
                nodes.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.nodes"}));
        }
        if (allNodes != null) {
            for (NodeInfo node : allNodes) {
                if (node.getStatus().equals((Object)Status.UNKNOWN)) continue;
                list.add(node.getNodeInfoBean());
            }
        }
        if (!list.isEmpty()) {
            Collections.sort(list, new Comparator<NodeInfoBean>(){

                @Override
                public int compare(NodeInfoBean o1, NodeInfoBean o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeInfoBean> getNodesByFilter(String nodesFilter) throws Exception {
        Filter filter = null;
        try {
            filter = Filter.parse((String)nodesFilter);
        }
        catch (Exception e) {
            filter = new Filter();
            filter.add(new FilterToken(NodeFilterFields.NAME.getName(), ""));
        }
        String nodesPermString = filter.get(NodeFilterFields.NAME.getName());
        if (!(nodesPermString != null && nodesPermString.trim().length() != 0 || (nodesPermString = filter.get(NodeFilterFields.HOSTNAME.getName())) != null && nodesPermString.trim().length() != 0)) {
            nodesPermString = "*";
        }
        String permission = "search:nodes:" + nodesPermString.toLowerCase();
        this.checkAuthorization((Permission)new StringPermission(permission));
        IMap nodes = this.getInstance().getMap("org.pepstock.jem.nodes");
        NodePredicate predicate = new NodePredicate(filter);
        ArrayList<NodeInfoBean> list = new ArrayList<NodeInfoBean>();
        Collection allNodes = null;
        if (nodes.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                allNodes = nodes.values((Predicate)predicate);
            }
            finally {
                nodes.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.nodes"}));
        }
        if (allNodes != null) {
            for (NodeInfo node : allNodes) {
                if (node.getStatus().equals((Object)Status.UNKNOWN)) continue;
                list.add(node.getNodeInfoBean());
            }
        }
        return list;
    }

    public Boolean drain(Collection<NodeInfoBean> nodes) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("nodes:drain"));
        IMap members_map = this.getInstance().getMap("org.pepstock.jem.nodes");
        Boolean result = Boolean.TRUE;
        for (NodeInfoBean node : nodes) {
            String key;
            if (node.isSuperNode() || node.getStatus().equalsIgnoreCase(Status.UNKNOWN.getDescription()) || !members_map.containsKey((Object)(key = node.getKey()))) continue;
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Drain(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
                executorService.execute((Runnable)task);
            }
        }
        return result;
    }

    public Boolean start(Collection<NodeInfoBean> nodes) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("nodes:start"));
        IMap members_map = this.getInstance().getMap("org.pepstock.jem.nodes");
        Boolean result = Boolean.TRUE;
        for (NodeInfoBean node : nodes) {
            String key;
            if (node.isSuperNode() || node.getStatus().equalsIgnoreCase(Status.UNKNOWN.getDescription()) || !members_map.containsKey((Object)(key = node.getKey()))) continue;
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Start(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
                executorService.execute((Runnable)task);
            }
        }
        return result;
    }

    private Boolean shutdown(Collection<NodeInfoBean> nodes) throws Exception {
        this.checkAuthentication();
        IMap members_map = this.getInstance().getMap("org.pepstock.jem.nodes");
        Boolean result = Boolean.TRUE;
        for (NodeInfoBean node : nodes) {
            String key;
            if (node.isSuperNode() || node.getStatus().equalsIgnoreCase(Status.UNKNOWN.getDescription()) || !members_map.containsKey((Object)(key = node.getKey()))) continue;
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Shutdown(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
                executorService.execute((Runnable)task);
            }
        }
        return result;
    }

    public Boolean update(NodeInfoBean node) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("nodes:update"));
        Boolean result = Boolean.TRUE;
        Member member = this.getMember(node.getKey());
        DistributedTask task = new DistributedTask((Callable)new Update(node), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
        executorService.execute((Runnable)task);
        return result;
    }

    public ConfigurationFile getNodeConfigFile(NodeInfoBean node, String what) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:configuration"));
        ConfigurationFile result = null;
        Member member = this.getMember(node.getKey());
        DistributedTask task = null;
        if (what != null) {
            if (what.equalsIgnoreCase("jem.config")) {
                task = new DistributedTask((Callable)new GetJemConfiguration(), member);
            } else if (what.equalsIgnoreCase("affinity")) {
                task = new DistributedTask((Callable)new GetAffinityPolicy(), member);
            }
        } else {
            task = new DistributedTask((Callable)new GetJemConfiguration(), member);
        }
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (ConfigurationFile)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public ConfigurationFile saveNodeConfigFile(NodeInfoBean node, ConfigurationFile file, String what) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:configuration"));
        ConfigurationFile result = null;
        Member member = this.getMember(node.getKey());
        DistributedTask task = null;
        if (what != null) {
            if (what.equalsIgnoreCase("jem.config")) {
                this.checkConfigFile(file.getContent(), what);
                task = new DistributedTask((Callable)new SaveJemConfiguration(file), member);
            } else if (what.equalsIgnoreCase("affinity")) {
                this.checkAffinityPolicy(node, file.getContent());
                task = new DistributedTask((Callable)new SaveAffinityPolicy(file), member);
            }
        } else {
            task = new DistributedTask((Callable)new SaveJemConfiguration(file), member);
        }
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (ConfigurationFile)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public Boolean checkConfigFile(String content, String what) throws Exception {
        try {
            this.checkAuthorization((Permission)new StringPermission("administration:nodes:configuration"));
        }
        catch (Exception e1) {
            this.checkAuthorization((Permission)new StringPermission("administration:cluster:configuration"));
        }
        Member member = this.getMember();
        DistributedTask task = null;
        if (what != null) {
            if (what.equalsIgnoreCase("jem.config")) {
                task = new DistributedTask((Callable)new CheckJemConfiguration(content), member);
            } else if (what.equalsIgnoreCase("jem.env")) {
                task = new DistributedTask((Callable)new CheckJemEnvConfiguration(content), member);
            } else if (what.equalsIgnoreCase("hazelcast.config")) {
                task = new DistributedTask((Callable)new CheckHazelcastConfiguration(content), member);
            }
        } else {
            task = new DistributedTask((Callable)new CheckJemConfiguration(content), member);
        }
        Boolean result = Boolean.TRUE;
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (Boolean)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public Result checkAffinityPolicy(NodeInfoBean node, String content) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:configuration"));
        Member member = this.getMember(node.getKey());
        Result result = null;
        DistributedTask task = new DistributedTask((Callable)new CheckAffinityPolicy(content), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (Result)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public ConfigurationFile getEnvConfigFile(String what) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:cluster:configuration"));
        ConfigurationFile result = null;
        Member member = this.getMember();
        DistributedTask task = null;
        if (what != null) {
            if (what.equalsIgnoreCase("hazelcast.config")) {
                task = new DistributedTask((Callable)new GetHazelcastConfiguration(), member);
            } else if (what.equalsIgnoreCase("jem.env")) {
                task = new DistributedTask((Callable)new GetJemEnvConfiguration(), member);
            }
        } else {
            task = new DistributedTask((Callable)new GetJemEnvConfiguration(), member);
        }
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (ConfigurationFile)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public ConfigurationFile saveEnvConfigFile(ConfigurationFile file, String what) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:cluster:configuration"));
        ConfigurationFile result = null;
        Member member = this.getMember();
        DistributedTask task = null;
        if (what != null) {
            if (what.equalsIgnoreCase("hazelcast.config")) {
                this.checkConfigFile(file.getContent(), what);
                task = new DistributedTask((Callable)new SaveHazelcastConfiguration(file), member);
            } else if (what.equalsIgnoreCase("jem.env")) {
                this.checkConfigFile(file.getContent(), what);
                task = new DistributedTask((Callable)new SaveJemEnvConfiguration(file), member);
            }
        } else {
            task = new DistributedTask((Callable)new SaveJemEnvConfiguration(file), member);
        }
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (ConfigurationFile)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    public String top(NodeInfoBean node) throws Exception {
        String key;
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:commands"));
        String result = null;
        IMap members_map = this.getInstance().getMap("org.pepstock.jem.nodes");
        if (!node.isSuperNode() && !node.getStatus().equalsIgnoreCase(Status.UNKNOWN.getDescription()) && members_map.containsKey((Object)(key = node.getKey()))) {
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new Top(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                executorService.execute((Runnable)task);
                try {
                    result = (String)task.get();
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public String log(NodeInfoBean node) throws Exception {
        String key;
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:commands"));
        String result = null;
        IMap members_map = this.getInstance().getMap("org.pepstock.jem.nodes");
        if (!node.isSuperNode() && !node.getStatus().equalsIgnoreCase(Status.UNKNOWN.getDescription()) && members_map.containsKey((Object)(key = node.getKey()))) {
            Cluster cluster = this.getInstance().getCluster();
            Set set = cluster.getMembers();
            for (Member member : set) {
                String memberKey = member.getUuid();
                if (!node.getKey().equalsIgnoreCase(memberKey)) continue;
                DistributedTask task = new DistributedTask((Callable)new GetLog(), member);
                ExecutorService executorService = this.getInstance().getExecutorService();
                executorService.execute((Runnable)task);
                try {
                    result = (String)task.get();
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    public String displayCluster(NodeInfoBean node) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:nodes:commands"));
        Cluster cluster = this.getInstance().getCluster();
        StringBuffer result = new StringBuffer("Members [").append(cluster.getMembers().size()).append("] {").append("\n");
        for (Member member : cluster.getMembers()) {
            String memberString = StringUtils.remove((String)member.toString(), (String)" this");
            if (node.getKey().equals(member.getUuid())) {
                memberString = memberString + " this";
            }
            result.append("    ").append(memberString).append("\n");
        }
        result.append("}\n");
        return result.toString();
    }
}

