/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.IMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.client.security.OrganizationalUnit;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.security.FirstInstallationManager;
import org.pepstock.jem.gwt.server.security.FirstInstallationToken;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.User;
import org.pepstock.jem.node.security.UserPreference;

public class LoginManager
extends DefaultService {
    public static final String USER_KEY = "JEM_USER";

    public LoginManager() {
        this.initRoles();
    }

    public LoggedUser getUser() throws Exception {
        Session session;
        Object object;
        Subject currentUser = SecurityUtils.getSubject();
        LoggedUser user = null;
        if (currentUser.isAuthenticated() && (object = (session = currentUser.getSession()).getAttribute((Object)USER_KEY)) != null && object instanceof LoggedUser) {
            user = (LoggedUser)object;
            user.setPreferences(this.getUserPreferences(user.getId()));
            session.setAttribute((Object)USER_KEY, (Object)user);
        }
        return user;
    }

    public LoggedUser login(String userid, String password) throws Exception {
        FirstInstallationManager fManager = FirstInstallationManager.getInstance();
        Subject currentUser = SecurityUtils.getSubject();
        FirstInstallationToken token = null;
        if (fManager.isFirstInstallationPhase()) {
            token = fManager.getToken();
            if (!userid.equalsIgnoreCase(token.getUsername())) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG010E, new Object[]{userid});
                String msg = UserInterfaceMessage.JEMG010E.toMessage().getFormattedMessage(new Object[]{userid});
                throw new Exception(msg);
            }
            token.setPassword(password.toCharArray());
        } else {
            token = new UsernamePasswordToken(userid, password);
            token.setRememberMe(true);
        }
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (UnknownAccountException uae) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG011E, new Object[]{token.getPrincipal().toString()});
            throw new Exception(UserInterfaceMessage.JEMG012E.toMessage().getMessage(), uae);
        }
        catch (IncorrectCredentialsException ice) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG013E, new Object[]{token.getPrincipal().toString()});
            throw new Exception(UserInterfaceMessage.JEMG012E.toMessage().getMessage(), ice);
        }
        catch (LockedAccountException lae) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG014E, new Object[]{token.getPrincipal().toString()});
            throw new Exception(UserInterfaceMessage.JEMG012E.toMessage().getMessage(), lae);
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG015E, (Throwable)ae, new Object[]{token.getPrincipal().toString(), ae.getMessage()});
            throw new Exception(UserInterfaceMessage.JEMG012E.toMessage().getMessage(), ae);
        }
        User userPrincipal = (User)currentUser.getPrincipal();
        String userId = userPrincipal.getId();
        String userName = userPrincipal.getName();
        String ouId = userPrincipal.getOrgUnitId();
        String ouName = userPrincipal.getOrgUnitName();
        LoggedUser user = new LoggedUser();
        user.setId(userId);
        if (userName != null) {
            user.setName(userName);
        } else {
            user.setName(userId);
        }
        OrganizationalUnit ou = new OrganizationalUnit();
        ou.setId(ouId);
        if (ouName != null) {
            ou.setName(ouName);
        } else {
            ou.setName(ouId);
        }
        user.setOrganizationalUnit(ou);
        Session shiroSession = currentUser.getSession();
        shiroSession.setAttribute((Object)USER_KEY, (Object)user);
        this.loadAuthorization(Permissions.VIEW_ALL, user);
        this.loadAuthorization(Permissions.JOBS_ALL, user);
        this.loadAuthorization(Permissions.NODES_ALL, user);
        this.loadAuthorization(Permissions.SWARM_NODES_ALL, user);
        this.loadAuthorization(Permissions.ROLES_ALL, user);
        this.loadAuthorization(Permissions.CERTIFICATES_ALL, user);
        this.loadAuthorization(Permissions.RESOURCES_ALL, user);
        this.loadAuthorization(Permissions.ADMINISTRATION_ITEMS_ALL, user);
        this.loadAuthorization(Permissions.ADMINISTRATION_ALL, user);
        this.loadAuthorization(Permissions.GFS_ALL, user);
        user.addAuthorized("administrator", currentUser.hasRole("administrator"));
        user.setPreferences(this.getUserPreferences(userId));
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG016I, new Object[]{user.toString()});
        return user;
    }

    private void loadAuthorization(String[] permissions, LoggedUser user) {
        Subject currentUser = SecurityUtils.getSubject();
        boolean[] b = currentUser.isPermitted(permissions);
        for (int i = 0; i < permissions.length; ++i) {
            user.addAuthorized(permissions[i], b[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap<String, UserPreference> getUserPreferences(String userId) {
        try {
            IMap map = this.getInstance().getMap("org.pepstock.jem.user.preferences");
            try {
                map.lock((Object)userId);
                if (map.containsKey((Object)userId)) {
                    HashMap hashMap = (HashMap)map.get((Object)userId);
                    return hashMap;
                }
                HashMap<String, UserPreference> hashMap = new HashMap<String, UserPreference>();
                return hashMap;
            }
            finally {
                map.unlock((Object)userId);
            }
        }
        catch (Exception e) {
            return new HashMap<String, UserPreference>();
        }
    }

    public Boolean logoff() throws Exception {
        return this.logoff(null);
    }

    public Boolean logoff(Map<String, UserPreference> preferences) throws Exception {
        if (preferences != null) {
            try {
                this.storePreferences(preferences);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        FirstInstallationManager fManager = FirstInstallationManager.getInstance();
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser != null) {
            Session shiroSession = currentUser.getSession();
            LoggedUser user = (LoggedUser)shiroSession.getAttribute((Object)USER_KEY);
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG017I, new Object[]{user != null ? user.toString() : currentUser.toString()});
            currentUser.logout();
            FirstInstallationToken token = fManager.getToken();
            if (fManager.isFirstInstallationPhase() && user.getId().equalsIgnoreCase(token.getUsername())) {
                IMap roles = this.getInstance().getMap("org.pepstock.jem.roles");
                fManager.cleanupGrantor((IMap<String, Role>)roles);
            }
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean storePreferences(Map<String, UserPreference> preferences) throws Exception {
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.isAuthenticated()) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG011E, new Object[]{"N/A"});
            throw new Exception(UserInterfaceMessage.JEMG012E.toMessage().getMessage());
        }
        User userPrincipal = (User)currentUser.getPrincipal();
        String userId = userPrincipal.getId();
        IMap map = this.getInstance().getMap("org.pepstock.jem.user.preferences");
        try {
            map.lock((Object)userId);
            if (map.containsKey((Object)userId)) {
                map.replace((Object)userId, preferences);
            } else {
                map.put((Object)userId, preferences);
            }
        }
        finally {
            map.unlock((Object)userId);
        }
        return Boolean.TRUE;
    }

    private void initRoles() {
        FirstInstallationManager fManager = FirstInstallationManager.getInstance();
        FirstInstallationToken token = fManager.getToken();
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG036I, new Object[]{token.getUsername()});
        IMap roles = this.getInstance().getMap("org.pepstock.jem.roles");
        try {
            fManager.addAdministratorIfAbsent((IMap<String, Role>)roles);
            fManager.addAOperatorIfAbsent((IMap<String, Role>)roles);
            fManager.addADeveloperIfAbsent((IMap<String, Role>)roles);
            fManager.addAGrantorIfAbsent((IMap<String, Role>)roles);
            fManager.setFirstInstallationPhase((IMap<String, Role>)roles);
            fManager.repairGrantor((IMap<String, Role>)roles);
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG032E, (Throwable)e);
        }
        if (fManager.isFirstInstallationPhase()) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG019W);
        }
    }
}

