/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.pepstock.jem.Jcl;
import org.pepstock.jem.Job;
import org.pepstock.jem.JobSystemActivity;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.Result;
import org.pepstock.jem.commands.util.Factory;
import org.pepstock.jem.gwt.client.commons.JobStatus;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.node.executors.GenericCallBack;
import org.pepstock.jem.node.executors.jobs.Cancel;
import org.pepstock.jem.node.executors.jobs.GetJclTypes;
import org.pepstock.jem.node.executors.jobs.GetJobSystemActivity;
import org.pepstock.jem.node.executors.jobs.GetOutputFileContent;
import org.pepstock.jem.node.executors.jobs.GetOutputTree;
import org.pepstock.jem.node.executors.jobs.Purge;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.JobFilterFields;
import org.pepstock.jem.util.filters.predicates.JobPredicate;
import org.w3c.dom.Document;

public class JobsManager
extends DefaultService {
    private static final MessageFormat jobIdFormat = new MessageFormat("{0,number}-{1,number}");

    public Collection<Job> getInputQueue(String filter) throws Exception {
        return this.getJobsByQueue("org.pepstock.jem.input", filter);
    }

    public Collection<Job> getRunningQueue(String filter) throws Exception {
        return this.getJobsByQueue("org.pepstock.jem.running", filter);
    }

    public Collection<Job> getOutputQueue(String filter) throws Exception {
        return this.getJobsByQueue("org.pepstock.jem.output", filter);
    }

    public Collection<Job> getRoutingQueue(String filter) throws Exception {
        return this.getJobsByQueue("org.pepstock.jem.routing", filter);
    }

    private Collection<Job> getJobsByQueue(String queueName, String filterString) throws Exception {
        Filter filter = null;
        try {
            filter = Filter.parse((String)filterString);
        }
        catch (Exception e) {
            filter = new Filter();
            filter.add(new FilterToken(JobFilterFields.NAME.getName(), ""));
        }
        String jobName = filter.get(JobFilterFields.NAME.getName());
        if (jobName == null || jobName.trim().length() == 0) {
            jobName = "*";
        }
        String permission = "search:jobs:" + jobName;
        this.checkAuthorization((Permission)new StringPermission(permission));
        IMap jobs = this.getInstance().getMap(queueName);
        JobPredicate predicate = new JobPredicate(filter);
        ArrayList<Job> list = null;
        list = new ArrayList<Job>(jobs.values((Predicate)predicate));
        return list;
    }

    public JobStatus getJobStatus(String filter) throws Exception {
        this.checkAuthentication();
        JobStatus status = new JobStatus();
        StringBuffer sb = new StringBuffer();
        try {
            jobIdFormat.parse(filter);
            sb.append("id = '").append(filter).append("'");
        }
        catch (ParseException pe) {
            String permission = "search:jobs:" + filter;
            this.checkAuthorization((Permission)new StringPermission(permission));
            sb.append("name = '").append(filter).append("'");
        }
        SqlPredicate predicate = new SqlPredicate(sb.toString());
        status.setJobsInput(this.loadQueuesJobs("org.pepstock.jem.input", predicate));
        status.setJobsRunning(this.loadQueuesJobs("org.pepstock.jem.running", predicate));
        status.setJobsOutput(this.loadQueuesJobs("org.pepstock.jem.output", predicate));
        status.setJobsRouting(this.loadQueuesJobs("org.pepstock.jem.routing", predicate));
        return status;
    }

    private Collection<Job> loadQueuesJobs(String queueName, SqlPredicate sql) throws Exception {
        IMap jobs = this.getInstance().getMap(queueName);
        ArrayList<Job> list = null;
        list = new ArrayList<Job>(jobs.values((Predicate)sql));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getJobById(String queueName, String jobId) throws Exception {
        this.checkAuthentication();
        Job job = null;
        IMap queue = this.getInstance().getMap(queueName);
        try {
            queue.lock((Object)jobId);
            if (queue.containsKey((Object)jobId)) {
                job = (Job)queue.get((Object)jobId);
            }
        }
        finally {
            queue.unlock((Object)jobId);
        }
        if (job != null) {
            String permission = "search:jobs:" + job.getName();
            this.checkAuthorization((Permission)new StringPermission(permission));
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job getEndedJobById(String jobId) throws Exception {
        this.checkAuthentication();
        Job job = this.getJobById("org.pepstock.jem.output", jobId);
        if (job == null) {
            IMap routedQueue = this.getInstance().getMap("org.pepstock.jem.routed");
            try {
                routedQueue.lock((Object)jobId);
                if (routedQueue.containsKey((Object)jobId)) {
                    job = (Job)routedQueue.remove((Object)jobId);
                }
            }
            finally {
                routedQueue.unlock((Object)jobId);
            }
            if (job != null) {
                String permission = "search:jobs:" + job.getName();
                this.checkAuthorization((Permission)new StringPermission(permission));
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hold(Collection<Job> jobs, String queueName) throws Exception {
        if (!(queueName.equalsIgnoreCase("org.pepstock.jem.input") || queueName.equalsIgnoreCase("org.pepstock.jem.output") || queueName.equalsIgnoreCase("org.pepstock.jem.routing"))) {
            return Boolean.FALSE;
        }
        this.checkAuthorization((Permission)new StringPermission("jobs:hold"));
        IMap queue = this.getInstance().getMap(queueName);
        for (Job job : jobs) {
            try {
                Job storedJob;
                Jcl storedJcl;
                queue.lock((Object)job.getId());
                if (!queue.containsKey((Object)job.getId()) || (storedJcl = (storedJob = (Job)queue.get((Object)job.getId())).getJcl()).isHold()) continue;
                storedJcl.setHold(true);
                queue.replace((Object)storedJob.getId(), (Object)storedJob);
            }
            finally {
                queue.unlock((Object)job.getId());
            }
        }
        return Boolean.TRUE;
    }

    public Boolean cancel(Collection<Job> jobs, boolean force) throws Exception {
        this.checkAuthorization((Permission)new StringPermission(force ? "jobs:kill" : "jobs:cancel"));
        Subject currentUser = SecurityUtils.getSubject();
        User user = (User)currentUser.getPrincipal();
        for (Job job : jobs) {
            String nodeKey = job.getMemberId();
            Member member = this.getMember(nodeKey);
            DistributedTask task = new DistributedTask((Callable)new Cancel(job, user.getId(), force), member);
            ExecutorService executorService = this.getInstance().getExecutorService();
            task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
            executorService.execute((Runnable)task);
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean release(Collection<Job> jobs, String queueName) throws Exception {
        if (!(queueName.equalsIgnoreCase("org.pepstock.jem.input") || queueName.equalsIgnoreCase("org.pepstock.jem.output") || queueName.equalsIgnoreCase("org.pepstock.jem.routing"))) {
            return Boolean.FALSE;
        }
        this.checkAuthorization((Permission)new StringPermission("jobs:release"));
        IMap queue = this.getInstance().getMap(queueName);
        for (Job job : jobs) {
            try {
                Job storedJob;
                Jcl storedJcl;
                queue.lock((Object)job.getId());
                if (!queue.containsKey((Object)job.getId()) || !(storedJcl = (storedJob = (Job)queue.get((Object)job.getId())).getJcl()).isHold()) continue;
                storedJcl.setHold(false);
                queue.replace((Object)storedJob.getId(), (Object)storedJob);
            }
            finally {
                queue.unlock((Object)job.getId());
            }
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean purge(Collection<Job> jobs, String queueName) throws Exception {
        if (!(queueName.equalsIgnoreCase("org.pepstock.jem.input") || queueName.equalsIgnoreCase("org.pepstock.jem.output") || queueName.equalsIgnoreCase("org.pepstock.jem.routing"))) {
            return Boolean.FALSE;
        }
        this.checkAuthorization((Permission)new StringPermission("jobs:purge"));
        Subject currentUser = SecurityUtils.getSubject();
        User user = (User)currentUser.getPrincipal();
        IMap queue = this.getInstance().getMap(queueName);
        for (Job job : jobs) {
            try {
                queue.lock((Object)job.getId());
                if (!queue.containsKey((Object)job.getId())) continue;
                Job storedJob = (Job)queue.get((Object)job.getId());
                Result result = new Result();
                result.setReturnCode(222);
                result.setExceptionMessage("Purge by user(" + user.getId() + ") interface");
                storedJob.setEndedTime(new Date());
                storedJob.setResult(result);
                queue.remove((Object)storedJob.getId());
                if (queueName.equalsIgnoreCase("org.pepstock.jem.output")) {
                    this.callPurge(storedJob);
                }
                ITopic topic = this.getInstance().getTopic("org.pepstock.jem.job.ended");
                topic.publish((Object)storedJob);
            }
            finally {
                queue.unlock((Object)job.getId());
            }
        }
        return Boolean.TRUE;
    }

    private void callPurge(Job storedJob) {
        try {
            Member member = this.getMember();
            DistributedTask task = new DistributedTask((Callable)new Purge(storedJob), member);
            ExecutorService executorService = this.getInstance().getExecutorService();
            task.setExecutionCallback((ExecutionCallback)new GenericCallBack());
            executorService.execute((Runnable)task);
        }
        catch (Exception e) {
            System.err.print(UserInterfaceMessage.JEMG054E.toMessage().getFormattedMessage(new Object[]{storedJob.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean update(Job job, String queueName) throws Exception {
        String permission = "search:jobs:" + job.getName();
        this.checkAuthorization((Permission)new StringPermission(permission));
        IMap queue = this.getInstance().getMap(queueName);
        try {
            queue.lock((Object)job.getId());
            if (queue.containsKey((Object)job.getId())) {
                Job storedJob = (Job)queue.get((Object)job.getId());
                Jcl storedJcl = storedJob.getJcl();
                job.getJcl().setContent(storedJcl.getContent());
                queue.replace((Object)job.getId(), (Object)job);
            }
        }
        finally {
            queue.unlock((Object)job.getId());
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJcl(Job job, String queueName) throws Exception {
        if (!(queueName.equalsIgnoreCase("org.pepstock.jem.input") || queueName.equalsIgnoreCase("org.pepstock.jem.output") || queueName.equalsIgnoreCase("org.pepstock.jem.running") || queueName.equalsIgnoreCase("org.pepstock.jem.routing"))) {
            throw new Exception(UserInterfaceMessage.JEMG025E.toMessage().getFormattedMessage(new Object[]{queueName}));
        }
        String permission = "search:jobs:" + job.getName();
        this.checkAuthorization((Permission)new StringPermission(permission));
        IMap queue = this.getInstance().getMap(queueName);
        Job storedJob = null;
        try {
            queue.lock((Object)job.getId());
            storedJob = (Job)queue.get((Object)job.getId());
        }
        finally {
            queue.unlock((Object)job.getId());
        }
        if (storedJob == null) {
            return "JCL not available";
        }
        return storedJob.getJcl().getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputTree getOutputTree(Job job, String queueName) throws Exception {
        OutputTree tree;
        if (!queueName.equalsIgnoreCase("org.pepstock.jem.output") && !queueName.equalsIgnoreCase("org.pepstock.jem.running")) {
            throw new Exception(UserInterfaceMessage.JEMG025E.toMessage().getFormattedMessage(new Object[]{queueName}));
        }
        String permission = "search:jobs:" + job.getName();
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetOutputTree(job), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            tree = (OutputTree)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        IMap queue = this.getInstance().getMap(queueName);
        Job storedJob = null;
        try {
            queue.lock((Object)job.getId());
            storedJob = (Job)queue.get((Object)job.getId());
        }
        finally {
            queue.unlock((Object)job.getId());
        }
        if (storedJob != null) {
            tree.setJclContent(storedJob.getJcl().getContent());
        } else {
            tree.setJclContent("JCL not available");
        }
        return tree;
    }

    public OutputFileContent getOutputFileContent(Job job, OutputListItem item) throws Exception {
        OutputFileContent content;
        String permission = "search:jobs:" + job.getName();
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetOutputFileContent(job, item), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            content = (OutputFileContent)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return content;
    }

    public String submit(PreJob preJob) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("jobs:submit"));
        Job job = preJob.getJob();
        Subject currentUser = SecurityUtils.getSubject();
        Object obj = currentUser.getPrincipal();
        if (obj instanceof User) {
            User user = (User)obj;
            job.setUser(user.getId());
            job.setOrgUnit(user.getOrgUnitId());
        }
        IdGenerator generator = this.getInstance().getIdGenerator("org.pepstock.jem.job.id");
        long id = generator.newId();
        String jobId = Factory.createJobId((Job)job, (long)id);
        job.setId(jobId);
        IQueue jclCheckingQueue = this.getInstance().getQueue("org.pepstock.jem.jcl.checking");
        try {
            jclCheckingQueue.put((Object)preJob);
        }
        catch (InterruptedException e) {
            throw new Exception(e);
        }
        return jobId;
    }

    public String indent(String content) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse((InputStream)new ReaderInputStream((Reader)new StringReader(content)));
        OutputFormat format = new OutputFormat(document);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(4);
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.serialize(document);
        return writer.toString();
    }

    public JobSystemActivity getJobSystemActivity(Job job) throws Exception {
        JobSystemActivity content;
        String permission = "search:jobs:" + job.getName();
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember(job.getMemberId());
        DistributedTask task = new DistributedTask((Callable)new GetJobSystemActivity(job), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            content = (JobSystemActivity)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return content;
    }

    public Map<String, String> getJclTypes() throws Exception {
        Map content;
        this.checkAuthorization((Permission)new StringPermission("jobs:submit"));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetJclTypes(), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            content = (Map)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return content;
    }
}

