/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.node.About;
import org.pepstock.jem.node.executors.DisplayRequestors;
import org.pepstock.jem.node.executors.GetAbout;
import org.pepstock.jem.node.persistence.RedoStatement;
import org.pepstock.jem.node.security.StringPermission;

public class InternalsManager
extends DefaultService {
    public String displayRequestors(String resourceKey) throws Exception {
        String result;
        this.checkAuthorization((Permission)new StringPermission("administration:cluster:grs"));
        Member member = this.getMember();
        DisplayRequestors executor = null;
        executor = resourceKey == null ? new DisplayRequestors() : (resourceKey.trim().equalsIgnoreCase("*") ? new DisplayRequestors() : new DisplayRequestors(resourceKey));
        DistributedTask task = new DistributedTask((Callable)executor, member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (String)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RedoStatement> getAllRedoStatements() throws Exception {
        this.checkAuthorization((Permission)new StringPermission("administration:cluster:redo"));
        IMap redos = this.getInstance().getMap("org.pepstock.jem.redo");
        ArrayList<RedoStatement> list = null;
        try {
            redos.lockMap(10L, TimeUnit.SECONDS);
            list = new ArrayList<RedoStatement>(redos.values());
            Collections.sort(list, new Comparator<RedoStatement>(){

                @Override
                public int compare(RedoStatement r1, RedoStatement r2) {
                    return r1.getId().compareTo(r2.getId());
                }
            });
        }
        finally {
            redos.unlockMap();
        }
        return list;
    }

    public About getAbout() throws Exception {
        About content;
        this.checkAuthentication();
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetAbout(), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            content = (About)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return content;
    }
}

