/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.executors.gfs.GetFile;
import org.pepstock.jem.node.executors.gfs.GetFilesList;
import org.pepstock.jem.node.security.RegExpPermission;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;

public class GfsManager
extends DefaultService {
    public Collection<GfsFile> getFilesList(int type, String path) throws Exception {
        Collection result;
        this.checkAuthentication();
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetFilesList(type, path), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (Collection)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        boolean checkAuth = !result.isEmpty();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            GfsFile file = (GfsFile)iter.next();
            boolean match = this.match(file);
            if (match) continue;
            iter.remove();
        }
        if (checkAuth && result.isEmpty()) {
            Subject currentUser = SecurityUtils.getSubject();
            Session shiroSession = currentUser.getSession();
            LoggedUser user = (LoggedUser)shiroSession.getAttribute((Object)"JEM_USER");
            String userid = user != null ? user.toString() : currentUser.toString();
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG008E, new Object[]{userid, path});
            String msg = UserInterfaceMessage.JEMG008E.toMessage().getFormattedMessage(new Object[]{userid, path});
            throw new Exception(msg);
        }
        return result;
    }

    public String getFile(int type, String file) throws Exception {
        String result;
        String filesPermission = "files:read:" + file;
        this.checkAuthorization((Permission)new StringPermission(filesPermission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetFile(type, file), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            result = (String)task.get();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return result;
    }

    private boolean match(GfsFile file) {
        Subject currentUser = SecurityUtils.getSubject();
        User userPrincipal = (User)currentUser.getPrincipal();
        if (currentUser.hasRole("administrator")) {
            return true;
        }
        String filesPermission = "files:read:" + file.getLongName();
        if (currentUser.isPermitted((Permission)new StringPermission(filesPermission))) {
            return true;
        }
        filesPermission = "files:write:" + file.getLongName();
        if (currentUser.isPermitted((Permission)new StringPermission(filesPermission))) {
            return true;
        }
        for (Permission permission : userPrincipal.getPermissions()) {
            String permString = permission.toString();
            if (permission instanceof RegExpPermission) {
                RegExpPermission regex = (RegExpPermission)permission;
                permString = regex.getPermissionPattern();
            }
            if (!permString.startsWith("files")) continue;
            if (permString.equals("files:.*") || permString.equals("files:read:*") || permString.equals("files:write:*")) {
                return true;
            }
            String filePattern = null;
            if (permString.startsWith("files:read:")) {
                filePattern = StringUtils.removeStart((String)permString, (String)"files:read:");
            } else if (permString.startsWith("files:write:")) {
                filePattern = StringUtils.removeStart((String)permString, (String)"files:write:");
            }
            if (filePattern == null || filePattern.length() <= file.getLongName().length() || !filePattern.startsWith(file.getLongName())) continue;
            return true;
        }
        return false;
    }
}

