/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeInfo;

public class DefaultService {
    private HazelcastInstance instance = SharedObjects.getInstance().getLocalMember();

    public DefaultService() {
        if (this.instance == null) {
            throw new IllegalArgumentException(UserInterfaceMessage.JEMG024E.toMessage().getFormattedMessage(new Object[0]));
        }
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void checkAdministrator() throws Exception {
        this.checkAuthentication();
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.hasRole("administrator")) {
            return;
        }
        Session shiroSession = currentUser.getSession();
        LoggedUser user = (LoggedUser)shiroSession.getAttribute((Object)"JEM_USER");
        String userid = user != null ? user.toString() : currentUser.toString();
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG008E, new Object[]{userid, "administrator"});
        String msg = UserInterfaceMessage.JEMG008E.toMessage().getFormattedMessage(new Object[]{userid, "administrator"});
        throw new Exception(msg);
    }

    public void checkAuthentication() throws Exception {
        this.checkAuthorization(null);
    }

    public void checkAuthorization(Permission permission) throws Exception {
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isAuthenticated()) {
            if (permission != null) {
                if (currentUser.isPermitted(permission)) {
                    return;
                }
                Session shiroSession = currentUser.getSession();
                LoggedUser user = (LoggedUser)shiroSession.getAttribute((Object)"JEM_USER");
                String userid = user != null ? user.toString() : currentUser.toString();
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG008E, new Object[]{userid, permission});
                String msg = UserInterfaceMessage.JEMG008E.toMessage().getFormattedMessage(new Object[]{userid, permission});
                throw new Exception(msg);
            }
            return;
        }
        Session shiroSession = currentUser.getSession();
        LoggedUser user = (LoggedUser)shiroSession.getAttribute((Object)"JEM_USER");
        String userid = user != null ? user.toString() : "N/A";
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG009E, new Object[]{userid});
        String msg = UserInterfaceMessage.JEMG009E.toMessage().getFormattedMessage(new Object[]{userid});
        throw new Exception(msg);
    }

    public NodeInfo searchAvailableNodeInfo() throws Exception {
        IMap map = this.getInstance().getMap("org.pepstock.jem.nodes");
        NodeInfo node = this.getNode((IMap<String, NodeInfo>)map, "status.index = 3");
        if (node != null) {
            return node;
        }
        node = this.getNode((IMap<String, NodeInfo>)map, "status.index = 1");
        if (node != null) {
            return node;
        }
        node = this.getNode((IMap<String, NodeInfo>)map, "status.index IN (0, 2, 4)");
        if (node != null) {
            return node;
        }
        throw new Exception(UserInterfaceMessage.JEMG023E.toMessage().getFormattedMessage(new Object[]{"searchAvailableNodeInfo"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeInfo getNode(IMap<String, NodeInfo> map, String predicateString) {
        Collection nodes;
        StringBuffer sb = new StringBuffer();
        sb.append(predicateString);
        SqlPredicate predicate = new SqlPredicate(sb.toString());
        if (map.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                nodes = map.values((Predicate)predicate);
            }
            finally {
                map.unlockMap();
            }
        } else {
            nodes = new ArrayList();
        }
        if (!nodes.isEmpty()) {
            for (NodeInfo node : nodes) {
                if (node.isSuperNode()) continue;
                return node;
            }
        }
        return null;
    }

    public Member getMember() throws Exception {
        return this.getMember(this.searchAvailableNodeInfo());
    }

    public Member getMember(NodeInfo node) throws Exception {
        return this.getMember(node.getKey());
    }

    public Member getMember(String nodeId) throws Exception {
        Cluster cluster = this.getInstance().getCluster();
        Set set = cluster.getMembers();
        for (Member member : set) {
            if (member.isLiteMember() || !member.getUuid().equalsIgnoreCase(nodeId)) continue;
            return member;
        }
        throw new Exception(UserInterfaceMessage.JEMG023E.toMessage().getFormattedMessage(new Object[]{"searchMember"}));
    }
}

