/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.subject.Subject;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.executors.certificates.GetCryptedValueAndHash;
import org.pepstock.jem.node.resources.CryptedValueAndHash;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.security.StringPermission;
import org.pepstock.jem.node.security.User;
import org.pepstock.jem.util.filters.Filter;
import org.pepstock.jem.util.filters.FilterToken;
import org.pepstock.jem.util.filters.fields.ResourceFilterFields;
import org.pepstock.jem.util.filters.predicates.ResourcePredicate;

public class CommonResourcesManager
extends DefaultService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(Resource resource) throws Exception {
        this.checkAuthentication();
        IMap map = this.getInstance().getMap("org.pepstock.jem.common.resources");
        if (map.containsKey((Object)resource.getName())) {
            this.checkAuthorization((Permission)new StringPermission("resources:update"));
            try {
                map.lock((Object)resource.getName());
                Resource oldResource = (Resource)map.get((Object)resource.getName());
                if (oldResource.getUser() != null && !oldResource.getUser().equalsIgnoreCase(resource.getUser())) {
                    LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldResource, resource});
                    throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldResource, resource}));
                }
                if (oldResource.getLastModified() != null && !oldResource.getLastModified().equals(resource.getLastModified())) {
                    LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG047E, new Object[]{oldResource, resource});
                    throw new Exception(UserInterfaceMessage.JEMG047E.toMessage().getFormattedMessage(new Object[]{oldResource, resource}));
                }
                Subject currentUser = SecurityUtils.getSubject();
                User userPrincipal = (User)currentUser.getPrincipal();
                String userId = userPrincipal.getId();
                resource.setUser(userId);
                resource.setLastModified(new Date());
                map.replace((Object)resource.getName(), (Object)resource);
            }
            finally {
                map.unlock((Object)resource.getName());
            }
            return false;
        }
        this.checkAuthorization((Permission)new StringPermission("resources:create"));
        try {
            map.lock((Object)resource.getName());
            Subject currentUser = SecurityUtils.getSubject();
            User userPrincipal = (User)currentUser.getPrincipal();
            String userId = userPrincipal.getId();
            resource.setUser(userId);
            resource.setLastModified(new Date());
            map.put((Object)resource.getName(), (Object)resource);
        }
        finally {
            map.unlock((Object)resource.getName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource get(String name) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("resources:read"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.common.resources");
        if (map.containsKey((Object)name)) {
            Resource resource = null;
            try {
                map.lock((Object)name);
                resource = (Resource)map.get((Object)name);
            }
            finally {
                map.unlock((Object)name);
            }
            return resource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String name) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("resources:delete"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.common.resources");
        if (map.containsKey((Object)name)) {
            Resource resource = null;
            try {
                map.lock((Object)name);
                resource = (Resource)map.remove((Object)name);
            }
            finally {
                map.unlock((Object)name);
            }
            return resource != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Resource> values(String filter) throws Exception {
        ResourcePredicate predicate;
        this.checkAuthorization((Permission)new StringPermission("resources:read"));
        IMap map = this.getInstance().getMap("org.pepstock.jem.common.resources");
        try {
            predicate = new ResourcePredicate(Filter.parse((String)filter));
        }
        catch (Exception e) {
            Filter all = new Filter();
            all.add(new FilterToken(ResourceFilterFields.NAME.getName(), ""));
            predicate = new ResourcePredicate(all);
        }
        Collection result = null;
        if (map.lockMap(10L, TimeUnit.SECONDS)) {
            try {
                result = map.values((Predicate)predicate);
            }
            finally {
                map.unlockMap();
            }
        } else {
            throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.common.resources"}));
        }
        return result;
    }

    public CryptedValueAndHash getEncryptedSecret(String secret) throws Exception {
        CryptedValueAndHash crypt;
        this.checkAuthorization((Permission)new StringPermission("resources:create"));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetCryptedValueAndHash(secret), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            crypt = (CryptedValueAndHash)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return crypt;
    }
}

