/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.node.executors.resources.GetResourceDefinitions;
import org.pepstock.jem.node.executors.resources.GetResourceDescriptor;
import org.pepstock.jem.node.executors.resources.GetResourceNames;
import org.pepstock.jem.node.resources.custom.ResourceDefinition;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;
import org.pepstock.jem.node.security.StringPermission;

public class CommonResourceDefinitionsManager
extends DefaultService {
    public Collection<ResourceDefinition> getAllDefinitions() throws Exception {
        String permission = "resources:read";
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetResourceDefinitions(), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        return (Collection)task.get();
    }

    public Collection<String> getAllResourceNames() throws Exception {
        String permission = "resources:read";
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetResourceNames(), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        return (Collection)task.get();
    }

    public ResourceDescriptor getDescriptorOf(String resourceName) throws Exception {
        String permission = "resources:read";
        this.checkAuthorization((Permission)new StringPermission(permission));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetResourceDescriptor(resourceName), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        return (ResourceDescriptor)task.get();
    }

    public Collection<ResourceDescriptor> getAllDescriptors() throws Exception {
        String permission = "resources:read";
        this.checkAuthorization((Permission)new StringPermission(permission));
        Collection<ResourceDefinition> content = this.getAllDefinitions();
        ArrayList<ResourceDescriptor> toReturn = new ArrayList<ResourceDescriptor>();
        if (content != null) {
            for (ResourceDefinition rd : content) {
                toReturn.add(rd.getResourceDescriptor());
            }
        }
        return toReturn;
    }
}

