/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.services;

import com.hazelcast.core.DistributedTask;
import com.hazelcast.core.Member;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.Permission;
import org.pepstock.jem.gwt.server.services.DefaultService;
import org.pepstock.jem.node.executors.certificates.AddCertificate;
import org.pepstock.jem.node.executors.certificates.GetCertificates;
import org.pepstock.jem.node.executors.certificates.RemoveCertificate;
import org.pepstock.jem.node.security.CertificateEntry;
import org.pepstock.jem.node.security.StringPermission;

public class CertificatesManager
extends DefaultService {
    public Collection<CertificateEntry> getCertificates(String filter) throws Exception {
        Collection content;
        this.checkAuthorization((Permission)new StringPermission("certificates:read"));
        if (filter.equals("*")) {
            filter = "";
        } else if (filter.endsWith("*")) {
            filter = StringUtils.substringBeforeLast((String)filter, (String)"*");
        }
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new GetCertificates(filter), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            content = (Collection)task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return content;
    }

    public Boolean addCertificate(byte[] certificate, String alias) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("certificates:create"));
        Member member = this.getMember();
        DistributedTask task = new DistributedTask((Callable)new AddCertificate(certificate, alias), member);
        ExecutorService executorService = this.getInstance().getExecutorService();
        executorService.execute((Runnable)task);
        try {
            task.get();
        }
        catch (InterruptedException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            throw new Exception(e.getMessage(), e);
        }
        return Boolean.TRUE;
    }

    public Boolean removeCertificate(Collection<CertificateEntry> entries) throws Exception {
        this.checkAuthorization((Permission)new StringPermission("certificates:delete"));
        Member member = this.getMember();
        for (CertificateEntry entry : entries) {
            DistributedTask task = new DistributedTask((Callable)new RemoveCertificate(entry.getAlias()), member);
            ExecutorService executorService = this.getInstance().getExecutorService();
            executorService.execute((Runnable)task);
            try {
                task.get();
            }
            catch (InterruptedException e) {
                throw new Exception(e.getMessage(), e);
            }
            catch (ExecutionException e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        return Boolean.TRUE;
    }
}

