/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.security;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.pepstock.jem.gwt.server.security.Authorizator;
import org.pepstock.jem.gwt.server.security.FirstInstallationManager;
import org.pepstock.jem.gwt.server.security.FirstInstallationToken;
import org.pepstock.jem.node.security.PrincipalAttribute;
import org.pepstock.jem.node.security.User;

public class NullAuthenticatorRealm
extends AuthorizingRealm {
    private Authorizator authorizator = null;
    private String users = null;
    private final Properties properties = new Properties();
    private static final MessageFormat USER_FORMAT = new MessageFormat("{0}[{1}]");

    public NullAuthenticatorRealm() {
        this((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.authorizator = new Authorizator();
    }

    public NullAuthenticatorRealm(CacheManager cacheManager) {
        this(cacheManager, (CredentialsMatcher)new AllowAllCredentialsMatcher());
    }

    public NullAuthenticatorRealm(CredentialsMatcher matcher) {
        super(matcher);
    }

    public NullAuthenticatorRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        super(cacheManager, matcher);
    }

    public String getUsers() {
        return this.users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    protected void onInit() {
        super.onInit();
        if (this.users != null) {
            String[] usersArray = this.users.split(",");
            for (int i = 0; i < usersArray.length; ++i) {
                try {
                    Object[] user_and_group = USER_FORMAT.parse(usersArray[i]);
                    this.properties.setProperty(user_and_group[0].toString().trim(), user_and_group[1].toString().trim());
                    continue;
                }
                catch (ParseException e) {
                    this.properties.setProperty(usersArray[i].trim(), usersArray[i].trim());
                }
            }
        }
        FirstInstallationManager manager = FirstInstallationManager.getInstance();
        manager.setToken(new FirstInstallationToken("grantor", null));
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (token instanceof FirstInstallationToken) {
            FirstInstallationToken upToken = (FirstInstallationToken)token;
            User user = new User(upToken.getUsername());
            SimpleAccount account = new SimpleAccount((Object)user, (Object)"nothing", this.getName());
            return account;
        }
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        if (!this.properties.containsKey(upToken.getUsername())) {
            throw new UnknownAccountException(upToken.getUsername() + " is unknown");
        }
        ArrayList<PrincipalAttribute> principals = new ArrayList<PrincipalAttribute>();
        PrincipalAttribute group = new PrincipalAttribute();
        group.setName("organizationalUnit");
        group.setValue((Object)this.properties.getProperty(upToken.getUsername()));
        principals.add(group);
        User user = new User(upToken.getUsername());
        user.setAttributes(principals);
        user.setOrgUnitId(this.properties.getProperty(upToken.getUsername()));
        SimpleAccount account = new SimpleAccount((Object)user, token.getCredentials(), this.getName());
        return account;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            return this.authorizator.doGetAuthorizationInfo((Realm)this, principals);
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
    }
}

