/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.security;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

public class JemCache<K, V>
implements Cache<K, V>,
MembershipListener {
    private String name = null;
    private ConcurrentMap<K, V> map = null;
    private boolean memory = true;

    public JemCache(String name) {
        this.setName(name);
        Cluster cluster = SharedObjects.getInstance().getLocalMember().getCluster();
        cluster.addMembershipListener((MembershipListener)this);
        if (SharedObjects.getInstance().isDataClusterAvailable()) {
            this.setHazelcastCache();
        } else {
            this.setMemoryCache();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isMemory() {
        return this.memory;
    }

    public void setMemory(boolean memory) {
        this.memory = memory;
    }

    public void clear() throws CacheException {
        this.map.clear();
    }

    public V get(K arg0) throws CacheException {
        return this.map.get(arg0);
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public V put(K arg0, V arg1) throws CacheException {
        return this.map.put(arg0, arg1);
    }

    public V remove(K arg0) throws CacheException {
        return this.map.remove(arg0);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<V> values() {
        return this.map.values();
    }

    public void memberAdded(MembershipEvent event) {
        Member member = event.getMember();
        if (!SharedObjects.getInstance().isDataClusterAvailable()) {
            if (!member.isLiteMember()) {
                this.setHazelcastCache();
            }
        } else if (this.isMemory()) {
            this.setHazelcastCache();
        }
    }

    public void memberRemoved(MembershipEvent event) {
        Member memberRemoved = event.getMember();
        if (memberRemoved.isLiteMember()) {
            return;
        }
        Cluster cluster = SharedObjects.getInstance().getLocalMember().getCluster();
        Set setMembers = cluster.getMembers();
        for (Member member : setMembers) {
            if (member.isLiteMember()) continue;
            return;
        }
        this.setMemoryCache();
    }

    private void setHazelcastCache() {
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG020I, new Object[]{"HAZELCAST"});
        HazelcastInstance instance = SharedObjects.getInstance().getLocalMember();
        this.map = instance.getMap(this.getName());
        this.setMemory(false);
    }

    private void setMemoryCache() {
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG020I, new Object[]{"MEMORY"});
        this.map = new ConcurrentHashMap();
        this.setMemory(true);
    }
}

