/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.security;

import com.hazelcast.core.IMap;
import java.util.ArrayList;
import org.pepstock.jem.gwt.server.security.FirstInstallationToken;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.Roles;

public class FirstInstallationManager {
    private static FirstInstallationManager MANAGER = null;
    private FirstInstallationToken token = null;
    private boolean isFirstInstallationPhase = true;

    public static FirstInstallationManager getInstance() {
        if (MANAGER == null) {
            MANAGER = new FirstInstallationManager();
        }
        return MANAGER;
    }

    public FirstInstallationToken getToken() {
        return this.token;
    }

    public void setToken(FirstInstallationToken token) {
        this.token = token;
    }

    public boolean isFirstInstallationPhase() {
        return this.isFirstInstallationPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstInstallationPhase(IMap<String, Role> roles) {
        Role admin = null;
        try {
            roles.lock((Object)Roles.ADMINISTRATOR_ROLE.getName());
            admin = (Role)roles.get((Object)Roles.ADMINISTRATOR_ROLE.getName());
        }
        finally {
            roles.unlock((Object)Roles.ADMINISTRATOR_ROLE.getName());
        }
        this.isFirstInstallationPhase = admin.getUsers().isEmpty();
    }

    public void addAdministratorIfAbsent(IMap<String, Role> roles) {
        if (roles.containsKey((Object)Roles.ADMINISTRATOR_ROLE.getName())) {
            return;
        }
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("*");
        Roles.ADMINISTRATOR_ROLE.setPermissions(perms);
        roles.putIfAbsent((Object)Roles.ADMINISTRATOR_ROLE.getName(), (Object)Roles.ADMINISTRATOR_ROLE);
    }

    public void addAOperatorIfAbsent(IMap<String, Role> roles) {
        if (roles.containsKey((Object)Roles.OPERATOR_ROLE.getName())) {
            return;
        }
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("view:input");
        perms.add("view:running");
        perms.add("view:routing");
        perms.add("view:output");
        perms.add("view:nodes");
        perms.add("jobs:*");
        perms.add("nodes:*");
        perms.add("swarm-nodes:start");
        perms.add("swarm-nodes:drain");
        perms.add("search:jobs:.*");
        perms.add("search:nodes:.*");
        Roles.OPERATOR_ROLE.setPermissions(perms);
        roles.putIfAbsent((Object)Roles.OPERATOR_ROLE.getName(), (Object)Roles.OPERATOR_ROLE);
    }

    public void addADeveloperIfAbsent(IMap<String, Role> roles) {
        if (roles.containsKey((Object)Roles.DEVELOPER_ROLE.getName())) {
            return;
        }
        ArrayList<String> perms = new ArrayList<String>();
        perms.add("view:input");
        perms.add("view:running");
        perms.add("view:routing");
        perms.add("view:output");
        Roles.DEVELOPER_ROLE.setPermissions(perms);
        roles.putIfAbsent((Object)Roles.DEVELOPER_ROLE.getName(), (Object)Roles.DEVELOPER_ROLE);
    }

    public void addAGrantorIfAbsent(IMap<String, Role> roles) {
        if (roles.containsKey((Object)Roles.GRANTOR_ROLE.getName())) {
            return;
        }
        ArrayList<String> perms = new ArrayList<String>();
        ArrayList<String> users = new ArrayList<String>();
        users.add(this.token.getUsername());
        Roles.GRANTOR_ROLE.setUsers(users);
        perms.add("view:roles");
        perms.add("roles:*");
        Roles.GRANTOR_ROLE.setPermissions(perms);
        roles.putIfAbsent((Object)Roles.GRANTOR_ROLE.getName(), (Object)Roles.GRANTOR_ROLE);
    }

    public void repairGrantor(IMap<String, Role> roles) {
        if (this.isFirstInstallationPhase) {
            Role grantors = (Role)roles.get((Object)Roles.GRANTOR_ROLE.getName());
            if (!grantors.getUsers().contains(this.token.getUsername())) {
                grantors.getUsers().add(this.token.getUsername());
            }
            if (!grantors.getPermissions().contains("view:roles")) {
                grantors.getPermissions().add("view:roles");
            }
            if (!grantors.getPermissions().contains("roles:*")) {
                grantors.getPermissions().add("roles:*");
            }
            roles.replace((Object)Roles.GRANTOR_ROLE.getName(), (Object)grantors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupGrantor(IMap<String, Role> roles) {
        this.setFirstInstallationPhase(roles);
        if (!this.isFirstInstallationPhase) {
            try {
                roles.lock((Object)Roles.GRANTOR_ROLE.getName());
                Role grantor = (Role)roles.get((Object)Roles.GRANTOR_ROLE.getName());
                ArrayList<String> users = new ArrayList<String>();
                for (String userID : grantor.getUsers()) {
                    if (userID.equalsIgnoreCase(this.token.getUsername())) continue;
                    users.add(userID);
                }
                grantor.setUsers(users);
                roles.replace((Object)Roles.GRANTOR_ROLE.getName(), (Object)grantor);
            }
            finally {
                roles.unlock((Object)Roles.GRANTOR_ROLE.getName());
            }
        }
    }
}

