/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.security;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.CollectionUtils;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.RegExpPermission;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.RolesQueuePredicate;
import org.pepstock.jem.node.security.User;

public class Authorizator {
    private HazelcastInstance instance = null;

    public Authorizator() {
        if (this.instance == null) {
            this.instance = SharedObjects.getInstance().getLocalMember();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationInfo doGetAuthorizationInfo(Realm realm, PrincipalCollection principals) throws Exception {
        User user = (User)this.getAvailablePrincipal(realm, principals);
        SimpleAccount account = new SimpleAccount((Object)user, (Object)"nothing", realm.getName());
        RolesQueuePredicate predicate = new RolesQueuePredicate();
        predicate.setUser(user);
        try {
            IMap roles = this.instance.getMap("org.pepstock.jem.roles");
            Collection myroles = null;
            if (roles.lockMap(10L, TimeUnit.SECONDS)) {
                try {
                    myroles = roles.values((Predicate)predicate);
                }
                finally {
                    roles.unlockMap();
                }
            } else {
                throw new Exception(UserInterfaceMessage.JEMG022E.toMessage().getFormattedMessage(new Object[]{"org.pepstock.jem.roles"}));
            }
            ArrayList<RegExpPermission> perms = new ArrayList<RegExpPermission>();
            for (Role role : myroles) {
                account.addRole(role.getName());
                for (String permission : role.getPermissions()) {
                    if (permission.startsWith("search") || permission.startsWith("datasources") || permission.startsWith("files") || permission.startsWith("surrogate")) {
                        RegExpPermission perm = new RegExpPermission(permission);
                        account.addObjectPermission((Permission)perm);
                        perms.add(perm);
                        continue;
                    }
                    account.addStringPermission(permission);
                }
            }
            user.setPermissions(perms);
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG031E, (Throwable)e, new Object[]{user.getId()});
        }
        return account;
    }

    private Object getAvailablePrincipal(Realm realm, PrincipalCollection principals) {
        Object primary = null;
        if (!CollectionUtils.isEmpty((PrincipalCollection)principals)) {
            Collection thisPrincipals = principals.fromRealm(realm.getName());
            primary = !CollectionUtils.isEmpty((Collection)thisPrincipals) ? thisPrincipals.iterator().next() : principals.getPrimaryPrincipal();
        }
        return primary;
    }
}

