/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.rest;

import java.util.Collection;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.pepstock.jem.GfsFile;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.rest.DefaultServerResource;
import org.pepstock.jem.gwt.server.rest.entities.GfsFileList;
import org.pepstock.jem.gwt.server.rest.entities.GfsOutputContent;
import org.pepstock.jem.gwt.server.services.GfsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

@Path(value="/gfs")
public class GfsManagerImpl
extends DefaultServerResource {
    public static final String GFS_MANAGER_PATH = "gfs";
    public static final String GFS_MANAGER_FILE_LIST = "ls";
    public static final String GFS_MANAGER_FILE_DATA = "data";
    public static final String GFS_MANAGER_FILE_LIBRARY = "lib";
    public static final String GFS_MANAGER_FILE_SOURCE = "src";
    public static final String GFS_MANAGER_FILE_CLASS = "class";
    public static final String GFS_MANAGER_FILE_BINARY = "bin";
    public static final String GFS_MANAGER_OUTPUT_FILE_CONTENT_PATH = "cat";
    private GfsManager gfsManager = null;

    @POST
    @Path(value="/ls/data")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesListData(String path) throws Exception {
        return this.getFilesList(0, path);
    }

    @POST
    @Path(value="/ls/lib")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesListLibrary(String path) throws Exception {
        return this.getFilesList(1, path);
    }

    @POST
    @Path(value="/ls/src")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesListSource(String path) throws Exception {
        return this.getFilesList(2, path);
    }

    @POST
    @Path(value="/ls/class")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesListClass(String path) throws Exception {
        return this.getFilesList(3, path);
    }

    @POST
    @Path(value="/ls/bin")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesListBinary(String path) throws Exception {
        return this.getFilesList(4, path);
    }

    @POST
    @Path(value="/ls")
    @Produces(value={"application/xml", "application/json"})
    public GfsFileList getFilesList(int type, String path) throws Exception {
        GfsFileList gfsContainer = new GfsFileList();
        if (this.isEnable()) {
            if (this.gfsManager == null) {
                this.initManager();
            }
            try {
                Collection<GfsFile> gfsList = this.gfsManager.getFilesList(type, path);
                gfsContainer.setGfsFiles(gfsList);
                gfsContainer.setPath(path);
            }
            catch (Exception e) {
                gfsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            gfsContainer.setExceptionMessage(msg);
        }
        return gfsContainer;
    }

    @POST
    @Path(value="/cat/data")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFileData(String path) throws Exception {
        return this.getFile(0, path);
    }

    @POST
    @Path(value="/cat/lib")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFileLibrary(String path) throws Exception {
        return this.getFile(1, path);
    }

    @POST
    @Path(value="/cat/src")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFileSource(String path) throws Exception {
        return this.getFile(2, path);
    }

    @POST
    @Path(value="/cat/class")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFileClass(String path) throws Exception {
        return this.getFile(3, path);
    }

    @POST
    @Path(value="/cat/bin")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFileBinary(String path) throws Exception {
        return this.getFile(4, path);
    }

    @POST
    @Path(value="/cat")
    @Produces(value={"application/xml", "application/json"})
    public GfsOutputContent getFile(int type, String file) throws Exception {
        GfsFileList gfsContainer = new GfsFileList();
        GfsOutputContent gfsFile = new GfsOutputContent();
        if (this.isEnable()) {
            if (this.gfsManager == null) {
                this.initManager();
            }
            try {
                gfsFile.setContent(this.gfsManager.getFile(type, file));
            }
            catch (Exception e) {
                gfsContainer.setExceptionMessage(e.getMessage());
            }
        } else {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG003E, new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            String msg = UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()});
            gfsContainer.setExceptionMessage(msg);
        }
        return gfsFile;
    }

    private synchronized void initManager() {
        if (this.gfsManager == null) {
            this.gfsManager = new GfsManager();
        }
    }
}

