/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server.listeners;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipListener;
import java.io.FileNotFoundException;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.NodeInfoUtility;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.configuration.ConfigurationException;
import org.pepstock.jem.gwt.server.listeners.NodeListener;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.NodeInfo;
import org.pepstock.jem.node.Status;

public class StartUp
extends EnvironmentLoaderListener
implements ServletContextListener {
    public StartUp() {
        LogAppl.getInstance();
        SharedObjects.createInstance();
        System.setProperty("java.net.preferIPv4Stack", Boolean.TRUE.toString());
    }

    public void contextDestroyed(ServletContextEvent event) {
        SharedObjects.getInstance().getMainSwarm().shutDown();
        SharedObjects.getInstance().shutdownLocalMember();
        super.contextDestroyed(event);
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String contextPath = context.getRealPath(".");
        contextPath = contextPath.substring(0, contextPath.length() - 1);
        String hazelcastFile = context.getInitParameter("hazelcast.config");
        Boolean checkVersion = Boolean.valueOf(context.getInitParameter("jem.check.version"));
        SharedObjects.getInstance().setCheckVersion(checkVersion);
        if (hazelcastFile != null) {
            try {
                this.startHazelcast(contextPath, hazelcastFile);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException((Throwable)((Object)e));
            }
        } else {
            throw new RuntimeException(UserInterfaceMessage.JEMG021E.toMessage().getFormattedMessage(new Object[0]));
        }
        super.contextInitialized(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHazelcast(String contextPath, String hazelcastFile) throws ConfigurationException {
        FileSystemXmlConfig config;
        LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG006I);
        String filename = contextPath + hazelcastFile;
        try {
            config = new FileSystemXmlConfig(filename);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException(e);
        }
        config.setLiteMember(true);
        HazelcastInstance instance = Hazelcast.newHazelcastInstance((Config)config);
        SharedObjects.getInstance().setLocalMember(instance);
        Cluster cluster = instance.getCluster();
        cluster.addMembershipListener((MembershipListener)new NodeListener());
        Member currentMember = cluster.getLocalMember();
        String key = currentMember.getUuid();
        if (this.isDataAvailable(cluster)) {
            IMap members_map = instance.getMap("org.pepstock.jem.nodes");
            if (members_map.containsKey((Object)key)) {
                try {
                    members_map.lock((Object)key);
                    NodeInfo info = (NodeInfo)members_map.get((Object)key);
                    info.setStatus(Status.ACTIVE);
                    info.setSuperNode(true);
                    SharedObjects.getInstance().setInfo(info);
                    members_map.replace((Object)key, (Object)info);
                    LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG007I, new Object[]{info.getKey()});
                }
                finally {
                    members_map.unlock((Object)key);
                }
            } else {
                NodeInfo info = NodeInfoUtility.createNodeInfo(currentMember, contextPath);
                info.setSuperNode(true);
                info.setStatus(Status.ACTIVE);
                SharedObjects.getInstance().setInfo(info);
                NodeInfoUtility.checkAndStoreNodeInfo(info);
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG007I, new Object[]{info.getKey()});
            }
        } else {
            NodeInfo info = NodeInfoUtility.createNodeInfo(currentMember, contextPath);
            info.setSuperNode(true);
            info.setStatus(Status.ACTIVE);
            SharedObjects.getInstance().setInfo(info);
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG007I, new Object[]{info.getKey()});
        }
    }

    private boolean isDataAvailable(Cluster cluster) {
        Member member;
        Set members = cluster.getMembers();
        if (!members.isEmpty() && !(member = (Member)cluster.getMembers().iterator().next()).isLiteMember()) {
            SharedObjects.getInstance().setDataClusterAvailable(true);
            return true;
        }
        SharedObjects.getInstance().setDataClusterAvailable(false);
        return false;
    }
}

