/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.pepstock.jem.JemException;
import org.pepstock.jem.gwt.client.services.RolesManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.RolesManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.Role;

public class RolesManagerServiceImpl
extends DefaultManager
implements RolesManagerService {
    private static final long serialVersionUID = 1L;
    private transient RolesManager rolesManager = null;

    @Override
    public Collection<Role> getRoles(String filter) throws Exception {
        this.checkIsEnable();
        if (this.rolesManager == null) {
            this.initManager();
        }
        try {
            return this.rolesManager.getRoles(filter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean addRole(Role role) throws Exception {
        this.checkIsEnable();
        if (this.rolesManager == null) {
            this.initManager();
        }
        try {
            Boolean result = this.rolesManager.addRole(role);
            if (result.booleanValue()) {
                this.clearAuthorizationCache();
            }
            return result;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean updateRole(Role role) throws Exception {
        this.checkIsEnable();
        if (this.rolesManager == null) {
            this.initManager();
        }
        try {
            Boolean result = this.rolesManager.updateRole(role);
            if (result.booleanValue()) {
                this.clearAuthorizationCache();
            }
            return result;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean removeRole(Collection<Role> roles) throws Exception {
        this.checkIsEnable();
        if (this.rolesManager == null) {
            this.initManager();
        }
        try {
            Boolean result = this.rolesManager.removeRole(roles);
            if (result.booleanValue()) {
                this.clearAuthorizationCache();
            }
            return result;
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.rolesManager == null) {
            try {
                this.rolesManager = new RolesManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
                throw new JemException(ex.getMessage());
            }
        }
    }

    private void clearAuthorizationCache() {
        RealmSecurityManager mgr = (RealmSecurityManager)SecurityUtils.getSecurityManager();
        Collection realmCollection = mgr.getRealms();
        for (Realm realm : realmCollection) {
            AuthorizingRealm authz;
            if (!(realm instanceof AuthorizingRealm) || !(authz = (AuthorizingRealm)realm).isAuthorizationCachingEnabled()) continue;
            authz.getAuthorizationCache().clear();
        }
    }
}

