/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import java.util.Map;
import org.pepstock.jem.JemException;
import org.pepstock.jem.Job;
import org.pepstock.jem.JobSystemActivity;
import org.pepstock.jem.OutputFileContent;
import org.pepstock.jem.OutputListItem;
import org.pepstock.jem.OutputTree;
import org.pepstock.jem.PreJob;
import org.pepstock.jem.gwt.client.commons.JobStatus;
import org.pepstock.jem.gwt.client.services.JobsManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.JobsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;

public class JobsManagerServiceImpl
extends DefaultManager
implements JobsManagerService {
    private static final long serialVersionUID = 1L;
    private transient JobsManager jobsManager = null;

    @Override
    public Collection<Job> getInputQueue(String jobNameFilter) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getInputQueue(jobNameFilter);
        }
        catch (Exception ex) {
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Collection<Job> getRunningQueue(String jobNameFilter) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getRunningQueue(jobNameFilter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Collection<Job> getOutputQueue(String jobNameFilter) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getOutputQueue(jobNameFilter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Collection<Job> getRoutingQueue(String jobNameFilter) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getRoutingQueue(jobNameFilter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean hold(Collection<Job> jobs, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.hold(jobs, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean cancel(Collection<Job> jobs, boolean force) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.cancel(jobs, force);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean release(Collection<Job> jobs, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.release(jobs, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public String submit(String content, String type) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            PreJob preJob = new PreJob();
            preJob.setJclContent(content);
            Job job = new Job();
            preJob.setJob(job);
            preJob.setJclType(type);
            String id = this.jobsManager.submit(preJob);
            return UserInterfaceMessage.JEMG053I.toMessage().getFormattedMessage(new Object[]{id});
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public String indent(String content) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.indent(content);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean purge(Collection<Job> jobs, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.purge(jobs, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public String getJcl(Job job, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getJcl(job, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public OutputTree getOutputTree(Job job, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getOutputTree(job, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public OutputFileContent getOutputFileContent(Job job, OutputListItem item) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getOutputFileContent(job, item);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean update(Job job, String queueName) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.update(job, queueName);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public JobStatus getJobStatus(String filter) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getJobStatus(filter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public JobSystemActivity getJobSystemActivity(Job job) throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getJobSystemActivity(job);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Map<String, String> getJclTypes() throws Exception {
        this.checkIsEnable();
        if (this.jobsManager == null) {
            this.initManager();
        }
        try {
            return this.jobsManager.getJclTypes();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.jobsManager == null) {
            try {
                this.jobsManager = new JobsManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
                throw new JemException(ex.getMessage());
            }
        }
    }
}

