/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.pepstock.jem.gwt.client.services.InfoService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;
import org.pepstock.jem.gwt.server.services.InternalsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.About;
import org.pepstock.jem.node.NodeInfo;

public class InfoServiceImpl
extends DefaultManager
implements InfoService {
    private static final String JEM_LOGO_URL = "jem.logo.url";
    private static final String JEM_LOGO_LINK = "jem.logo.link";
    private static final long serialVersionUID = 1L;
    private transient InternalsManager internalsManager = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getEnvironmentInformation() throws Exception {
        this.checkIsEnable();
        this.initManager();
        String[] infos = new String[5];
        try {
            HazelcastInstance localMember = SharedObjects.getInstance().getLocalMember();
            infos[0] = localMember.getConfig().getGroupConfig().getName();
            int webNodes = 0;
            for (Member m : localMember.getCluster().getMembers()) {
                if (!m.isLiteMember()) continue;
                ++webNodes;
            }
            infos[1] = localMember.getCluster().getMembers().size() + " (" + webNodes + ")";
            IMap jobs = localMember.getMap("org.pepstock.jem.running");
            infos[2] = String.valueOf(jobs.size());
            Member oldest = (Member)localMember.getCluster().getMembers().iterator().next();
            IMap nodes = localMember.getMap("org.pepstock.jem.nodes");
            if (nodes.tryLock((Object)oldest.getUuid(), 10L, TimeUnit.SECONDS)) {
                try {
                    NodeInfo oldestInfo = (NodeInfo)nodes.get((Object)oldest.getUuid());
                    if (oldestInfo != null) {
                        infos[3] = String.valueOf(oldestInfo.getStartedTime().getTime());
                    }
                    infos[3] = "N/A";
                }
                finally {
                    nodes.unlock((Object)oldest.getUuid());
                }
            } else {
                infos[3] = "N/A";
            }
            infos[4] = String.valueOf(System.currentTimeMillis());
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG043E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
        return infos;
    }

    @Override
    public String[] getLogoURL() throws Exception {
        this.initManager();
        ServletContext context = super.getServletContext();
        String logoUrl = context.getInitParameter(JEM_LOGO_URL);
        String linkUrl = context.getInitParameter(JEM_LOGO_LINK);
        if (logoUrl != null) {
            String[] infos = new String[]{logoUrl, linkUrl};
            return infos;
        }
        return null;
    }

    @Override
    public About getAbout() throws Exception {
        this.checkIsEnable();
        this.initManager();
        try {
            return this.internalsManager.getAbout();
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
            throw new Exception(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.internalsManager == null) {
            try {
                this.internalsManager = new InternalsManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG038E, (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
    }
}

