/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.commons.SharedObjects;

public abstract class FileUploadManager
extends DefaultManager {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String message = null;
        if (this.isEnable()) {
            ServletRequestContext ss = new ServletRequestContext(request);
            boolean isMultiPart = ServletFileUpload.isMultipartContent((RequestContext)ss);
            if (!isMultiPart) {
                super.service(request, response);
                return;
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List items = upload.parseRequest(request);
                try {
                    String result = this.loaded(items);
                    message = this.getMessage(0, result);
                }
                catch (Exception e) {
                    message = this.getMessage(2, e.getMessage());
                }
            }
            catch (FileUploadException e) {
                message = this.getMessage(2, UserInterfaceMessage.JEMG049E.toMessage().getFormattedMessage(new Object[]{e.getMessage()}));
            }
        } else {
            message = this.getMessage(2, UserInterfaceMessage.JEMG003E.toMessage().getFormattedMessage(new Object[]{SharedObjects.getInstance().getLocalMember().getConfig().getGroupConfig().getName()}));
        }
        response.setContentType("text/plain");
        response.getWriter().print(message);
        response.flushBuffer();
        response.getWriter().close();
    }

    public abstract String loaded(List<FileItem> var1) throws Exception;

    private String getMessage(int returnCode, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append("<").append("result").append(">");
        sb.append("<").append("return-code").append(">");
        sb.append(returnCode);
        sb.append("</").append("return-code").append(">");
        sb.append("<").append("message").append(">");
        sb.append(message);
        sb.append("</").append("message").append(">");
        sb.append("</").append("result").append(">");
        return sb.toString();
    }
}

