/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import org.pepstock.jem.JemException;
import org.pepstock.jem.gwt.client.services.CustomResourceDefinitionsManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CommonResourceDefinitionsManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.resources.custom.ResourceDescriptor;

public class CustomResourceDefinitionsManagerServiceImpl
extends DefaultManager
implements CustomResourceDefinitionsManagerService {
    private static final long serialVersionUID = 1L;
    private transient CommonResourceDefinitionsManager customResourceDefinitionsManager = null;

    @Override
    public ResourceDescriptor getDescriptorOf(String resourceName) throws Exception {
        this.checkIsEnable();
        this.initManager();
        try {
            return this.customResourceDefinitionsManager.getDescriptorOf(resourceName);
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG055E, (Throwable)e);
            throw new JemException(e.getMessage());
        }
    }

    @Override
    public Collection<ResourceDescriptor> getAllResourceDescriptors() throws Exception {
        this.checkIsEnable();
        this.initManager();
        try {
            return this.customResourceDefinitionsManager.getAllDescriptors();
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG055E, (Throwable)e);
            throw new JemException(e.getMessage());
        }
    }

    @Override
    public Collection<String> getAllResourceNames() throws Exception {
        this.checkIsEnable();
        this.initManager();
        try {
            return this.customResourceDefinitionsManager.getAllResourceNames();
        }
        catch (Exception e) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG055E, (Throwable)e);
            throw new JemException(e.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.customResourceDefinitionsManager == null) {
            try {
                this.customResourceDefinitionsManager = new CommonResourceDefinitionsManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG055E, (Throwable)ex);
                throw new JemException(ex.getMessage());
            }
        }
    }
}

