/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.util.Collection;
import org.pepstock.jem.JemException;
import org.pepstock.jem.gwt.client.services.CertificatesManagerService;
import org.pepstock.jem.gwt.server.DefaultManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CertificatesManager;
import org.pepstock.jem.log.LogAppl;
import org.pepstock.jem.log.MessageInterface;
import org.pepstock.jem.node.security.CertificateEntry;

public class CertificatesManagerServiceImpl
extends DefaultManager
implements CertificatesManagerService {
    private static final long serialVersionUID = 1L;
    private transient CertificatesManager certificatesManager = null;

    @Override
    public Collection<CertificateEntry> getCertificates(String filter) throws Exception {
        this.checkIsEnable();
        if (this.certificatesManager == null) {
            this.initManager();
        }
        try {
            return this.certificatesManager.getCertificates(filter);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    @Override
    public Boolean removeCertificates(Collection<CertificateEntry> entries) throws Exception {
        this.checkIsEnable();
        if (this.certificatesManager == null) {
            this.initManager();
        }
        try {
            return this.certificatesManager.removeCertificate(entries);
        }
        catch (Exception ex) {
            LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
            throw new JemException(ex.getMessage());
        }
    }

    private synchronized void initManager() throws Exception {
        if (this.certificatesManager == null) {
            try {
                this.certificatesManager = new CertificatesManager();
            }
            catch (Exception ex) {
                LogAppl.getInstance().emit((MessageInterface)UserInterfaceMessage.JEMG041E, (Throwable)ex);
                throw new JemException(ex.getMessage());
            }
        }
    }
}

