/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.server;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.IOUtils;
import org.pepstock.jem.JemException;
import org.pepstock.jem.gwt.client.services.CertificateAdderManagerService;
import org.pepstock.jem.gwt.server.FileUploadManager;
import org.pepstock.jem.gwt.server.UserInterfaceMessage;
import org.pepstock.jem.gwt.server.services.CertificatesManager;

public class CertificateAdderManagerServiceImpl
extends FileUploadManager
implements CertificateAdderManagerService {
    private static final long serialVersionUID = 1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String loaded(List<FileItem> items) throws Exception {
        CertificatesManager manager = new CertificatesManager();
        byte[] certificate = null;
        String alias = null;
        for (FileItem item : items) {
            if (item.getFieldName().equalsIgnoreCase("certificate")) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)item.getInputStream(), (OutputStream)baos);
                certificate = baos.toByteArray();
                continue;
            }
            if (!item.getFieldName().equalsIgnoreCase("user")) continue;
            alias = item.getString();
        }
        if (alias == null) throw new JemException(UserInterfaceMessage.JEMG048E.toMessage().getFormattedMessage(new Object[]{"user"}));
        if (certificate == null) throw new JemException(UserInterfaceMessage.JEMG050E.toMessage().getFormattedMessage(new Object[]{"certificate"}));
        try {
            manager.addCertificate(certificate, alias);
            return UserInterfaceMessage.JEMG052I.toMessage().getFormattedMessage(new Object[]{alias});
        }
        catch (Exception e) {
            throw new JemException(UserInterfaceMessage.JEMG051E.toMessage().getFormattedMessage(new Object[]{e.getMessage()}));
        }
    }
}

