/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.security;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.LinkedList;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.security.LoggedUser;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.UserPreference;

public class CurrentUser {
    private static final CurrentUser CURRENT_USER = new CurrentUser();
    protected static final int PREFERENCES_STORE_INTERVAL = 30000;
    private long previousUpdateTime = 0L;
    private long lastUpdateTime = 0L;
    private LoggedUser user = null;

    private CurrentUser() {
        Timer preferencesStoreTimer = new Timer(){

            public void run() {
                if (CurrentUser.this.user != null) {
                    CurrentUser.this.storePreferences();
                }
            }
        };
        preferencesStoreTimer.run();
        preferencesStoreTimer.scheduleRepeating(30000);
    }

    public void storePreferences() {
        if (this.previousUpdateTime != this.lastUpdateTime) {
            Services.LOGIN_MANAGER.storePreferences(CurrentUser.getInstance().getUser().getPreferences(), (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                @Override
                public void onJemFailure(Throwable caught) {
                    caught.printStackTrace();
                }

                @Override
                public void onJemSuccess(Boolean result) {
                    CurrentUser.this.previousUpdateTime = CurrentUser.this.lastUpdateTime;
                }

                @Override
                public void onJemExecuted() {
                }
            });
        }
    }

    public static final CurrentUser getInstance() {
        return CURRENT_USER;
    }

    public LoggedUser getUser() {
        return this.user;
    }

    public void setUser(LoggedUser user) {
        this.user = user;
    }

    public String getStringPreference(String key) {
        UserPreference pref;
        if (key != null && (pref = CurrentUser.getInstance().getUser().getPreferences().get(key)) != null && pref.isValueString()) {
            return pref.getValueString();
        }
        return null;
    }

    public LinkedList<String> getListPreference(String key) {
        UserPreference pref;
        if (key != null && (pref = CurrentUser.getInstance().getUser().getPreferences().get(key)) != null && !pref.isValueString()) {
            return pref.getValueList();
        }
        return null;
    }

    public void setStringPreference(String key, String value) {
        if (key != null) {
            UserPreference pref = CurrentUser.getInstance().getUser().getPreferences().get(key);
            if (pref == null) {
                pref = new UserPreference();
            }
            pref.setValueString(value);
            this.getUser().getPreferences().put(key, pref);
            this.setLastUpdateTime();
        }
    }

    public void setListPreference(String key, LinkedList<String> value) {
        if (key != null) {
            UserPreference pref = new UserPreference();
            pref.setValueList(value);
            this.getUser().getPreferences().put(key, pref);
            this.setLastUpdateTime();
        }
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }
}

