/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.DefaultInspectorItem;
import org.pepstock.jem.gwt.client.commons.MandatoryNumericalTextBox;
import org.pepstock.jem.gwt.client.commons.MandatoryPasswordTextBox;
import org.pepstock.jem.gwt.client.commons.MandatoryTextBox;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class GeneralEditConfig
extends DefaultInspectorItem {
    private static final String ADDRESS_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";
    private DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
    private SwarmConfiguration swarmConfiguration = null;
    private MandatoryTextBox groupName = new MandatoryTextBox();
    private MandatoryPasswordTextBox groupPassword = new MandatoryPasswordTextBox();
    private MandatoryPasswordTextBox confirmedGroupPassword = new MandatoryPasswordTextBox();
    private MandatoryNumericalTextBox port = new MandatoryNumericalTextBox();
    private TextBox netInterface = new TextBox();
    private CheckBox isConfigurationEnabled = new CheckBox();
    private Label user = new Label();
    private Label lastModified = new Label();
    private final FlexTable table = new FlexTable();

    public GeneralEditConfig(SwarmConfiguration swarmConfiguration) {
        this.setSwarmConfiguration(swarmConfiguration);
        this.setWidth("100%");
        this.table.setWidth("100%");
        this.table.setCellPadding(5);
        this.table.setHTML(0, 0, "Enabled:");
        this.table.setWidget(0, 1, (Widget)this.isConfigurationEnabled);
        this.table.setHTML(1, 0, "Group name: <font color=\"red\"><b>*</b></font>");
        this.table.setWidget(1, 1, (Widget)this.groupName);
        this.table.setHTML(2, 0, "Group password: <font color=\"red\"><b>*</b></font>");
        this.table.setWidget(2, 1, (Widget)this.groupPassword);
        this.table.setHTML(3, 0, "Confirmed Group password: <font color=\"red\"><b>*</b></font>");
        this.table.setWidget(3, 1, (Widget)this.confirmedGroupPassword);
        this.table.setHTML(3, 2, "");
        this.table.setHTML(0, 3, "Port: <font color=\"red\"><b>*</b></font>");
        this.table.setWidget(0, 4, (Widget)this.port);
        this.table.setHTML(0, 5, "");
        this.table.setHTML(1, 3, "Network interface:");
        this.table.setWidget(1, 4, (Widget)this.netInterface);
        this.table.setHTML(1, 5, "");
        this.table.setHTML(2, 3, "User:");
        this.table.setWidget(2, 4, (Widget)this.user);
        this.table.setHTML(3, 3, "Last update:");
        this.table.setWidget(3, 4, (Widget)this.lastModified);
        this.table.setHTML(5, 0, "<font color=\"red\"><b>*</b></font> Mandatory.");
        FlexTable.FlexCellFormatter cf = this.table.getFlexCellFormatter();
        cf.setWordWrap(0, 0, false);
        cf.setWordWrap(1, 0, false);
        cf.setWordWrap(2, 0, false);
        cf.setWordWrap(3, 0, false);
        cf.setWordWrap(4, 0, false);
        cf.setWordWrap(5, 0, false);
        cf.setWordWrap(0, 3, false);
        cf.setWordWrap(1, 3, false);
        cf.setWordWrap(2, 3, false);
        cf.setWordWrap(3, 3, false);
        cf.addStyleName(0, 2, Styles.INSTANCE.common().textRed());
        cf.addStyleName(1, 2, Styles.INSTANCE.common().textRed());
        cf.addStyleName(2, 2, Styles.INSTANCE.common().textRed());
        cf.addStyleName(3, 2, Styles.INSTANCE.common().textRed());
        cf.addStyleName(0, 5, Styles.INSTANCE.common().textRed());
        cf.addStyleName(1, 5, Styles.INSTANCE.common().textRed());
        cf.setWidth(0, 0, Sizes.toString(200));
        cf.setWidth(0, 1, Sizes.toString(200));
        cf.setWidth(0, 3, Sizes.toString(200));
        cf.setWidth(0, 4, Sizes.toString(200));
        this.add((Widget)this.table);
    }

    public SwarmConfiguration getSwarmConfiguration() {
        return this.swarmConfiguration;
    }

    public void setSwarmConfiguration(SwarmConfiguration swarmConfiguration) {
        this.swarmConfiguration = swarmConfiguration;
        this.loadConfiguration();
    }

    private void loadConfiguration() {
        this.isConfigurationEnabled.setValue(Boolean.valueOf(this.swarmConfiguration.isEnabled()));
        this.groupName.setText(this.swarmConfiguration.getGroupName());
        this.groupPassword.setText(this.swarmConfiguration.getGroupPassword());
        this.confirmedGroupPassword.setText(this.swarmConfiguration.getGroupPassword());
        this.port.setText(String.valueOf(this.swarmConfiguration.getPort()));
        this.user.setText(this.swarmConfiguration.getUser());
        if (this.swarmConfiguration.getLastModified() != null) {
            this.lastModified.setText(this.dtf.format(this.swarmConfiguration.getLastModified()));
        }
    }

    private void clearErrors() {
        this.clearError(1, 2, this.groupName);
        this.clearError(2, 2, (TextBox)this.groupPassword);
        this.clearError(3, 2, (TextBox)this.confirmedGroupPassword);
        this.clearError(0, 5, this.port);
    }

    public boolean validate() {
        this.clearErrors();
        boolean ok = true;
        if (this.groupName.getText() == null || this.groupName.getText().length() == 0) {
            this.setError(1, 2, this.groupName, "Group name can not be empty");
            ok = false;
        } else {
            this.swarmConfiguration.setGroupName(this.groupName.getText());
        }
        if (this.groupPassword.getText() == null || this.groupPassword.getText().length() == 0) {
            this.setError(2, 2, (TextBox)this.groupPassword, "Group password can not be empty");
            ok = false;
        } else {
            this.swarmConfiguration.setGroupPassword(this.groupPassword.getText());
        }
        if (this.confirmedGroupPassword.getText() == null || !this.groupPassword.getText().equals(this.confirmedGroupPassword.getText())) {
            this.setError(3, 2, (TextBox)this.confirmedGroupPassword, "Group password is not confirmed");
            ok = false;
        }
        if (this.port.getText() == null || this.port.getText().length() == 0) {
            this.setError(0, 5, this.port, "Port can not be empty");
            ok = false;
        } else {
            try {
                int p = Integer.parseInt(this.port.getText());
                if (p <= 0) {
                    throw new NumberFormatException();
                }
                this.swarmConfiguration.setPort(p);
            }
            catch (NumberFormatException nfe) {
                this.setError(0, 5, this.port, "Port must be a positive integer");
                ok = false;
            }
        }
        if (this.netInterface.getText() != null && this.netInterface.getText().length() > 0) {
            if (!this.netInterface.getText().matches(ADDRESS_PATTERN)) {
                this.setError(1, 5, this.netInterface, "Network interface must a valid ip-address");
                ok = false;
            } else {
                this.swarmConfiguration.setNetworkInterface(this.netInterface.getText());
            }
        }
        this.swarmConfiguration.setEnabled(this.isConfigurationEnabled.getValue().booleanValue());
        return ok;
    }

    private void setError(int row, int col, TextBox textBox, String errorMsg) {
        this.table.setHTML(row, col, errorMsg);
        if (!textBox.getStyleName().contains(Styles.INSTANCE.common().textBoxError())) {
            textBox.addStyleName(Styles.INSTANCE.common().textBoxError());
        }
    }

    private void clearError(int row, int col, TextBox textBox) {
        this.table.setHTML(row, col, "");
        if (textBox.getStyleName().contains(Styles.INSTANCE.common().textBoxError())) {
            textBox.removeStyleName(Styles.INSTANCE.common().textBoxError());
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

