/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm.commons;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.swarm.NodeActionListener;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.Actions;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config.ConfigHeader;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config.GeneralEditConfig;
import org.pepstock.jem.gwt.client.panels.swarm.commons.inspector.config.NetworkEditConfig;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class EditConfigInspector
extends AbstractTabPanelInspector
implements NodeActionListener {
    private GeneralEditConfig genEditConf = null;
    private SwarmConfiguration swarmConfiguration = null;
    private TabPanel tabpanel = new TabPanel();
    private Actions action = new Actions();

    public EditConfigInspector(SwarmConfiguration swarmConfiguration) {
        super(true);
        this.setSwarmConfiguration(swarmConfiguration);
        this.genEditConf = new GeneralEditConfig(swarmConfiguration);
        this.tabpanel.add((Widget)this.genEditConf, "General");
        NetworkEditConfig netEditConf = new NetworkEditConfig(swarmConfiguration);
        this.tabpanel.add((Widget)netEditConf, "Members");
        this.tabpanel.selectTab(0);
        this.action.setListener(this);
    }

    public SwarmConfiguration getSwarmConfiguration() {
        return this.swarmConfiguration;
    }

    public void setSwarmConfiguration(SwarmConfiguration swarmConfiguration) {
        this.swarmConfiguration = swarmConfiguration;
    }

    @Override
    public void save() {
        if (this.genEditConf.validate()) {
            this.hide();
            Scheduler scheduler = Scheduler.get();
            scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    Services.ROUTING_CONFIG_MANAGER.updateSwarmConfiguration(EditConfigInspector.this.getSwarmConfiguration(), (AsyncCallback<SwarmConfiguration>)new ServiceAsyncCallback<SwarmConfiguration>(){

                        @Override
                        public void onJemFailure(Throwable caught) {
                            AlertMessageBox alert = new AlertMessageBox(2, " Update error!", caught.getMessage());
                            alert.open();
                        }

                        @Override
                        public void onJemSuccess(SwarmConfiguration result) {
                            if (result == null) {
                                AlertMessageBox alert = new AlertMessageBox(1, "Configuration empty!", "The result of routing configuration is empty!<br>Please contact your JEM adminitrator.");
                                alert.open();
                            }
                        }

                        @Override
                        public void onJemExecuted() {
                        }
                    });
                }
            });
        }
    }

    @Override
    public void cancel() {
        this.hide();
    }

    @Override
    public FlexTable getHeader() {
        return new ConfigHeader(this);
    }

    @Override
    public Panel getActions() {
        return this.action;
    }

    @Override
    public TabPanel getTabPanel() {
        return this.tabpanel;
    }
}

