/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.swarm;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.NodeInfoBean;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.NodeStatusImages;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.panels.swarm.commons.EditConfigInspector;
import org.pepstock.jem.gwt.client.panels.swarm.commons.ViewConfigInspector;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.configuration.SwarmConfiguration;

public class NodesActions
extends AbstractActionsButtonPanel<NodeInfoBean> {
    private HTML statusLabel = new HTML();

    public NodesActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addStatus();
        this.addStartButton();
        this.addStopButton();
        this.addConfButton();
    }

    private void addStatus() {
        this.add((Widget)this.statusLabel);
        this.getStatus();
    }

    private void setStatus(String statusString) {
        SafeHtmlBuilder sb = new SafeHtmlBuilder();
        NodeStatusImages statusObject = statusString.equals(NodeStatusImages.UNKNOWN.toString()) ? NodeStatusImages.UNKNOWN : (statusString.equals(NodeStatusImages.STARTING.toString()) ? NodeStatusImages.STARTING : (statusString.equals(NodeStatusImages.INACTIVE.toString()) ? NodeStatusImages.INACTIVE : (statusString.equals(NodeStatusImages.ACTIVE.toString()) ? NodeStatusImages.ACTIVE : (statusString.equals(NodeStatusImages.DRAINED.toString()) ? NodeStatusImages.DRAINED : (statusString.equals(NodeStatusImages.DRAINING.toString()) ? NodeStatusImages.DRAINING : (statusString.equals(NodeStatusImages.SHUTTING_DOWN.toString()) ? NodeStatusImages.SHUTTING_DOWN : NodeStatusImages.INACTIVE))))));
        sb.appendHtmlConstant("<table>");
        sb.appendHtmlConstant("<tr><td align='left' valign='middle'>Swarm is</td><td width='5px'/><td>");
        String imageHtml = AbstractImagePrototype.create((ImageResource)statusObject.getImage()).getHTML();
        sb.appendHtmlConstant(imageHtml);
        sb.appendHtmlConstant("</td>");
        sb.appendHtmlConstant("<td align='left' valign='middle'>");
        sb.appendEscaped(statusString);
        sb.appendHtmlConstant("</td><td width='15px'/></tr></table>");
        this.statusLabel.setHTML(sb.toSafeHtml());
    }

    private void addStartButton() {
        if (ClientPermissions.isAuthorized("swarm-nodes", "swarm-nodes:start")) {
            Button startButton = new Button("Start", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    NodesActions.this.start();
                }
            });
            this.add((Widget)startButton);
        }
    }

    private void addStopButton() {
        if (ClientPermissions.isAuthorized("swarm-nodes", "swarm-nodes:drain")) {
            Button drainButton = new Button("Drain", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    NodesActions.this.drain();
                }
            });
            this.add((Widget)drainButton);
        }
    }

    private void addConfButton() {
        if (ClientPermissions.isAuthorized("swarm-nodes", "swarm-nodes:editconfig")) {
            Button editButton = new Button("Edit Config", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    NodesActions.this.edit();
                }
            });
            this.add((Widget)editButton);
        } else if (ClientPermissions.isAuthorized("swarm-nodes", "swarm-nodes:viewconfig")) {
            Button viewButton = new Button("View Config", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    NodesActions.this.view();
                }
            });
            this.add((Widget)viewButton);
        }
    }

    private void drain() {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.SWARM_NODES_MANAGER.drain((AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            AlertMessageBox alert = new AlertMessageBox(0, "Swarm stopped!", "Swarm is stopped correctly!");
                            alert.open();
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Stop command warning!", "Some lite members are not stopped in swarm!");
                            alert.open();
                        }
                        NodesActions.this.getStatus();
                        if (NodesActions.this.getSearcher() != null) {
                            NodesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Stop command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    private void start() {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.SWARM_NODES_MANAGER.start((AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (result.booleanValue()) {
                            AlertMessageBox alert = new AlertMessageBox(0, "Swarm started!", "Swarm is started correctly!");
                            alert.open();
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Start command warning!", "Some lite members are not started in swarm!");
                            alert.open();
                        }
                        NodesActions.this.getStatus();
                        if (NodesActions.this.getSearcher() != null) {
                            NodesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Start command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    public void getStatus() {
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.SWARM_NODES_MANAGER.getStatus((AsyncCallback<String>)new ServiceAsyncCallback<String>(){

                    @Override
                    public void onJemSuccess(String result) {
                        if (result != null) {
                            NodesActions.this.setStatus(result);
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "getStatus ERROR!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                    }
                });
            }
        });
    }

    private void edit() {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.ROUTING_CONFIG_MANAGER.getSwarmConfiguration("ROUTING_CONFIGURATION", (AsyncCallback<SwarmConfiguration>)new ServiceAsyncCallback<SwarmConfiguration>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get configuration error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(SwarmConfiguration result) {
                        if (result != null) {
                            try {
                                EditConfigInspector inspector = new EditConfigInspector(result);
                                inspector.setModal(true);
                                inspector.setTitle("Swarm Configuration");
                                inspector.center();
                            }
                            catch (Exception e) {
                                AlertMessageBox alert = new AlertMessageBox(2, "EditConfig error!", e.getMessage());
                                alert.open();
                            }
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Configuration empty!", "The result of swarm configuration is empty!<br>Please contact your JEM adminitrator.");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }

    private void view() {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.ROUTING_CONFIG_MANAGER.getSwarmConfiguration("ROUTING_CONFIGURATION", (AsyncCallback<SwarmConfiguration>)new ServiceAsyncCallback<SwarmConfiguration>(){

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Get configuration error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemSuccess(SwarmConfiguration result) {
                        if (result != null) {
                            try {
                                ViewConfigInspector inspector = new ViewConfigInspector(result);
                                inspector.setModal(true);
                                inspector.setTitle("Swarm Configuraton");
                                inspector.center();
                            }
                            catch (Exception e) {
                                AlertMessageBox alert = new AlertMessageBox(2, "ViewConfig error!", e.getMessage());
                                alert.open();
                            }
                        } else {
                            AlertMessageBox alert = new AlertMessageBox(1, "Configuration empty!", "The result of swarm configuration is empty!<br>Please contact your JEM adminitrator.");
                            alert.open();
                        }
                    }

                    @Override
                    public void onJemExecuted() {
                        NodesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

