/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class ViewPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem viewAll = new PermissionItem("All", "allows to see all views", "view:*");
    private PermissionItem viewInput = new PermissionItem("Input", "allows to have INPUT queue view", "view:input");
    private PermissionItem viewRunning = new PermissionItem("Running", "allows to have RUNNING queue view", "view:running");
    private PermissionItem viewOutput = new PermissionItem("Output", "allows to have OUTPUT queue view", "view:output");
    private PermissionItem viewRouting = new PermissionItem("Routing", "allows to have ROUTING queue view", "view:routing");
    private PermissionItem viewAdmin = new PermissionItem("Administration", "allows to have ADMINISTRATION view", "view:admin");
    private PermissionItem viewNodes = new PermissionItem("Nodes", "allows to have NODES list view, to manage them", "view:nodes");
    private PermissionItem viewSwarm = new PermissionItem("Swarm", "allows to have SWARM node list view, to manage them", "view:swarm-nodes");
    private PermissionItem viewRoles = new PermissionItem("Roles", "allows to have ROLES list view, to manage them", "view:roles");
    private PermissionItem viewResources = new PermissionItem("Resources", "allows to have RESOURCES list view, to manage them", "view:resources");
    private PermissionItem viewStatus = new PermissionItem("Status", "allows to have STATUS queue view, to search a single job on queues", "view:status");
    private PermissionItem viewGfs = new PermissionItem("GFS explorer", "allows to have GFS explorer view, to navugate on GFS seeing existing files", "view:gfsexplorer");

    public ViewPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("view") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("view:*") || permission.startsWith("*")) {
                this.viewAll.setValue(true);
                for (int i = 0; i < Permissions.VIEW_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.VIEW_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.viewAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (ViewPermissionsPanel.this.viewAll.getValue()) {
                    if (!ViewPermissionsPanel.this.getRole().getPermissions().contains("view:*")) {
                        Iterator iter = ViewPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("view")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.VIEW_ALL.length; ++i) {
                            PermissionItem checkBox = ViewPermissionsPanel.this.getPermissionItemByPermission(Permissions.VIEW_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        ViewPermissionsPanel.this.getRole().getPermissions().add("view:*");
                    }
                } else {
                    ViewPermissionsPanel.this.getRole().getPermissions().remove("view:*");
                    for (int i = 0; i < Permissions.VIEW_ALL.length; ++i) {
                        PermissionItem checkBox = ViewPermissionsPanel.this.getPermissionItemByPermission(Permissions.VIEW_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.viewInput);
        this.loadCheckBoxAction(this.viewRunning);
        this.loadCheckBoxAction(this.viewOutput);
        this.loadCheckBoxAction(this.viewRouting);
        this.loadCheckBoxAction(this.viewStatus);
        this.loadCheckBoxAction(this.viewGfs);
        this.loadCheckBoxAction(this.viewAdmin);
        this.loadCheckBoxAction(this.viewNodes);
        this.loadCheckBoxAction(this.viewSwarm);
        this.loadCheckBoxAction(this.viewRoles);
        this.loadCheckBoxAction(this.viewResources);
        this.setItems(this.viewAll, this.viewInput, this.viewRunning, this.viewOutput, this.viewRouting, this.viewStatus, this.viewNodes, this.viewSwarm, this.viewRoles, this.viewResources, this.viewGfs, this.viewAdmin);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("view:input")) {
            return this.viewInput;
        }
        if (permission.equalsIgnoreCase("view:running")) {
            return this.viewRunning;
        }
        if (permission.equalsIgnoreCase("view:output")) {
            return this.viewOutput;
        }
        if (permission.equalsIgnoreCase("view:routing")) {
            return this.viewRouting;
        }
        if (permission.equalsIgnoreCase("view:status")) {
            return this.viewStatus;
        }
        if (permission.equalsIgnoreCase("view:gfsexplorer")) {
            return this.viewGfs;
        }
        if (permission.equalsIgnoreCase("view:admin")) {
            return this.viewAdmin;
        }
        if (permission.equalsIgnoreCase("view:roles")) {
            return this.viewRoles;
        }
        if (permission.equalsIgnoreCase("view:resources")) {
            return this.viewResources;
        }
        if (permission.equalsIgnoreCase("view:nodes")) {
            return this.viewNodes;
        }
        if (permission.equalsIgnoreCase("view:swarm-nodes")) {
            return this.viewSwarm;
        }
        if (permission.equalsIgnoreCase("view:*")) {
            return this.viewAll;
        }
        return null;
    }
}

