/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class SwarmPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem nodesAll = new PermissionItem("All", "allows to have all actions on swarm nodes", "swarm-nodes:*");
    private PermissionItem nodesViewConfig = new PermissionItem("View config", "allows to VIEW swarm cluster configuration", "swarm-nodes:viewconfig");
    private PermissionItem nodesEditConfig = new PermissionItem("Edit config", "allows to EDIT swarm cluster configurations", "swarm-nodes:editconfig");
    private PermissionItem nodesStart = new PermissionItem("Start", "allows to have START command to perform on swarm nodes", "swarm-nodes:start");
    private PermissionItem nodesDrain = new PermissionItem("Drain", "allows to have STOP command to perform on swarm nodes", "swarm-nodes:drain");

    public SwarmPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("swarm-nodes") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("swarm-nodes:*") || permission.startsWith("*")) {
                this.nodesAll.setValue(true);
                for (int i = 0; i < Permissions.NODES_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.SWARM_NODES_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.nodesAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (SwarmPermissionsPanel.this.nodesAll.getValue()) {
                    if (!SwarmPermissionsPanel.this.getRole().getPermissions().contains("swarm-nodes:*")) {
                        Iterator iter = SwarmPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("swarm-nodes")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.SWARM_NODES_ALL.length; ++i) {
                            PermissionItem checkBox = SwarmPermissionsPanel.this.getPermissionItemByPermission(Permissions.SWARM_NODES_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        SwarmPermissionsPanel.this.getRole().getPermissions().add("swarm-nodes:*");
                    }
                } else {
                    SwarmPermissionsPanel.this.getRole().getPermissions().remove("swarm-nodes:*");
                    for (int i = 0; i < Permissions.SWARM_NODES_ALL.length; ++i) {
                        PermissionItem checkBox = SwarmPermissionsPanel.this.getPermissionItemByPermission(Permissions.SWARM_NODES_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.nodesStart);
        this.loadCheckBoxAction(this.nodesDrain);
        this.loadCheckBoxAction(this.nodesViewConfig);
        this.loadCheckBoxAction(this.nodesEditConfig);
        this.setItems(this.nodesAll, this.nodesStart, this.nodesDrain, this.nodesViewConfig, this.nodesEditConfig);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("swarm-nodes:start")) {
            return this.nodesStart;
        }
        if (permission.equalsIgnoreCase("swarm-nodes:drain")) {
            return this.nodesDrain;
        }
        if (permission.equalsIgnoreCase("swarm-nodes:viewconfig")) {
            return this.nodesViewConfig;
        }
        if (permission.equalsIgnoreCase("swarm-nodes:editconfig")) {
            return this.nodesEditConfig;
        }
        if (permission.equalsIgnoreCase("swarm-nodes:*")) {
            return this.nodesAll;
        }
        return null;
    }
}

