/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class NodesPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem nodesAll = new PermissionItem("All", "allows to have all actions on nodes", "nodes:*");
    private PermissionItem nodesStart = new PermissionItem("Start", "allows to have START command to perform on nodes", "nodes:start");
    private PermissionItem nodesDrain = new PermissionItem("Drain", "allows to have DRAIN command to perform on nodes", "nodes:drain");
    private PermissionItem nodesUpdate = new PermissionItem("Update", "allows to have UPDATE affinities and domain on nodes", "nodes:update");

    public NodesPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("nodes") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("nodes:*") || permission.startsWith("*")) {
                this.nodesAll.setValue(true);
                for (int i = 0; i < Permissions.NODES_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.NODES_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.nodesAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (NodesPermissionsPanel.this.nodesAll.getValue()) {
                    if (!NodesPermissionsPanel.this.getRole().getPermissions().contains("nodes:*")) {
                        Iterator iter = NodesPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("nodes")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.NODES_ALL.length; ++i) {
                            PermissionItem checkBox = NodesPermissionsPanel.this.getPermissionItemByPermission(Permissions.NODES_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        NodesPermissionsPanel.this.getRole().getPermissions().add("nodes:*");
                    }
                } else {
                    NodesPermissionsPanel.this.getRole().getPermissions().remove("nodes:*");
                    for (int i = 0; i < Permissions.NODES_ALL.length; ++i) {
                        PermissionItem checkBox = NodesPermissionsPanel.this.getPermissionItemByPermission(Permissions.NODES_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.nodesStart);
        this.loadCheckBoxAction(this.nodesDrain);
        this.loadCheckBoxAction(this.nodesUpdate);
        this.setItems(this.nodesAll, this.nodesStart, this.nodesDrain, this.nodesUpdate);
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("nodes:start")) {
            return this.nodesStart;
        }
        if (permission.equalsIgnoreCase("nodes:drain")) {
            return this.nodesDrain;
        }
        if (permission.equalsIgnoreCase("nodes:update")) {
            return this.nodesUpdate;
        }
        if (permission.equalsIgnoreCase("nodes:*")) {
            return this.nodesAll;
        }
        return null;
    }
}

