/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector.permissions;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import java.util.Iterator;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.CheckBoxPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.PermissionItem;
import org.pepstock.jem.node.security.Permissions;
import org.pepstock.jem.node.security.Role;

public class AdministrationPermissionsPanel
extends CheckBoxPermissionsPanel {
    private PermissionItem adminAll = new PermissionItem("All", "allows to use all actions implemented in administration view", "administration:*");
    private PermissionItem adminClusterWorkload = new PermissionItem("Cluster workload", "allows to see workload chart (jobs submitted and checked)", "administration:cluster:workload");
    private PermissionItem adminClusterGrs = new PermissionItem("Cluster GRS", "allows to see all active contentions in the cluster", "administration:cluster:grs");
    private PermissionItem adminClusterRedo = new PermissionItem("Cluster Redo", "allows to see all REDO statements, if there are", "administration:cluster:redo");
    private PermissionItem adminClusterGfs = new PermissionItem("Cluster GFS usage", "allows to see the global file system usage", "administration:cluster:gfs-usage");
    private PermissionItem adminClusterMemory = new PermissionItem("Cluster Memory usage", "allows to see the memory usage in the cluster", "administration:cluster:memory-usage");
    private PermissionItem adminClusterConfig = new PermissionItem("Cluster configuration", "allows to manage environment configurations (both JEM and Hazelcast)", "administration:cluster:configuration");
    private PermissionItem adminNodesConfig = new PermissionItem("Nodes configuration", "allows to manage nodes configurations (both JEM and affinity loader)", "administration:nodes:configuration");
    private PermissionItem adminNodesCommand = new PermissionItem("Nodes commands", "allows to perform commands on nodes", "administration:nodes:commands");
    private PermissionItem adminNodesSystem = new PermissionItem("Nodes System statistics", "allows to see the resources consumption of nodes", "administration:nodes:system");
    private PermissionItem adminNodesQueue = new PermissionItem("Nodes Queues statistics", "allows to see the queues data distributionon nodes", "administration:nodes:queues");
    private PermissionItem adminQueuesCurrent = new PermissionItem("Queues current usage", "allows to see current utilization of queues", "administration:queues:current");
    private PermissionItem adminQueuesStats = new PermissionItem("Queues statistics", "allows to see last samples about utilization of queues", "administration:queues:statistics");
    private PermissionItem adminQueuesInternals = new PermissionItem("Internal Maps statistics", "allows to see last samples about utilization of internal maps", "administration:queues:internalMaps");
    private PermissionItem adminSecuritySecret = new PermissionItem("Security Secret utility", "allows to have SECRET utility to hash and crypt properties of common resources", "administration:security:secret");
    private PermissionItem adminSecurityCertificate = new PermissionItem("Security Certificate manager", "allows to manage all certificate of user, necessary with socket interceptor", "administration:security:certificate");

    public AdministrationPermissionsPanel(Role role) {
        super(role);
        for (String permission : role.getPermissions()) {
            if (!permission.startsWith("administration") && !permission.startsWith("*")) continue;
            if (permission.equalsIgnoreCase("administration:*") || permission.startsWith("*")) {
                this.adminAll.setValue(true);
                for (int i = 0; i < Permissions.ADMINISTRATION_ALL.length; ++i) {
                    PermissionItem checkBox = this.getPermissionItemByPermission(Permissions.ADMINISTRATION_ALL[i]);
                    if (checkBox == null) continue;
                    checkBox.setValue(false);
                    checkBox.setEnabled(false);
                }
                continue;
            }
            PermissionItem checkBox = this.getPermissionItemByPermission(permission);
            if (checkBox == null) continue;
            checkBox.setValue(true);
        }
        this.adminAll.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (AdministrationPermissionsPanel.this.adminAll.getValue()) {
                    if (!AdministrationPermissionsPanel.this.getRole().getPermissions().contains("administration:*")) {
                        Iterator iter = AdministrationPermissionsPanel.this.getRole().getPermissions().iterator();
                        while (iter.hasNext()) {
                            String permission = (String)iter.next();
                            if (!permission.startsWith("administration")) continue;
                            iter.remove();
                        }
                        for (int i = 0; i < Permissions.ADMINISTRATION_ALL.length; ++i) {
                            PermissionItem checkBox = AdministrationPermissionsPanel.this.getPermissionItemByPermission(Permissions.ADMINISTRATION_ALL[i]);
                            if (checkBox == null) continue;
                            checkBox.setValue(false);
                            checkBox.setEnabled(false);
                        }
                        AdministrationPermissionsPanel.this.getRole().getPermissions().add("administration:*");
                    }
                } else {
                    AdministrationPermissionsPanel.this.getRole().getPermissions().remove("administration:*");
                    for (int i = 0; i < Permissions.ADMINISTRATION_ALL.length; ++i) {
                        PermissionItem checkBox = AdministrationPermissionsPanel.this.getPermissionItemByPermission(Permissions.ADMINISTRATION_ALL[i]);
                        if (checkBox == null) continue;
                        checkBox.setEnabled(true);
                    }
                }
            }
        });
        this.loadCheckBoxAction(this.adminClusterConfig);
        this.loadCheckBoxAction(this.adminClusterWorkload);
        this.loadCheckBoxAction(this.adminClusterGrs);
        this.loadCheckBoxAction(this.adminClusterRedo);
        this.loadCheckBoxAction(this.adminClusterGfs);
        this.loadCheckBoxAction(this.adminClusterMemory);
        this.loadCheckBoxAction(this.adminNodesConfig);
        this.loadCheckBoxAction(this.adminNodesCommand);
        this.loadCheckBoxAction(this.adminNodesSystem);
        this.loadCheckBoxAction(this.adminNodesQueue);
        this.loadCheckBoxAction(this.adminQueuesCurrent);
        this.loadCheckBoxAction(this.adminQueuesStats);
        this.loadCheckBoxAction(this.adminQueuesInternals);
        this.loadCheckBoxAction(this.adminSecuritySecret);
        this.loadCheckBoxAction(this.adminSecurityCertificate);
        this.setItems(this.adminAll, this.adminClusterConfig, this.adminClusterWorkload, this.adminClusterGrs, this.adminClusterRedo, this.adminClusterGfs, this.adminClusterMemory, this.adminNodesConfig, this.adminNodesCommand, this.adminNodesSystem, this.adminNodesQueue, this.adminQueuesCurrent, this.adminQueuesStats, this.adminQueuesInternals, this.adminSecuritySecret, this.adminSecurityCertificate);
    }

    @Override
    public void loadCheckBoxAction(final PermissionItem item) {
        super.loadCheckBoxAction(item);
        item.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                AdministrationPermissionsPanel.this.addPermission(item, "administration:cluster", "administration:cluster:folder");
                AdministrationPermissionsPanel.this.addPermission(item, "administration:nodes", "administration:nodes:folder");
                AdministrationPermissionsPanel.this.addPermission(item, "administration:queues", "administration:queues:folder");
                AdministrationPermissionsPanel.this.addPermission(item, "administration:security", "administration:security:folder");
            }
        });
    }

    private void addPermission(PermissionItem item, String mainPermission, String folder) {
        block2: {
            block3: {
                if (!item.getPermission().startsWith(mainPermission)) break block2;
                if (!item.getValue()) break block3;
                if (this.getRole().getPermissions().contains(folder)) break block2;
                this.getRole().getPermissions().add(folder);
                break block2;
            }
            if (this.getRole().getPermissions().contains(folder)) {
                this.getRole().getPermissions().remove(folder);
                for (String perm : this.getRole().getPermissions()) {
                    if (!perm.startsWith(mainPermission)) continue;
                    this.getRole().getPermissions().add(folder);
                    break;
                }
            }
        }
    }

    private PermissionItem getPermissionItemByPermission(String permission) {
        if (permission.equalsIgnoreCase("administration:cluster:workload")) {
            return this.adminClusterWorkload;
        }
        if (permission.equalsIgnoreCase("administration:cluster:grs")) {
            return this.adminClusterGrs;
        }
        if (permission.equalsIgnoreCase("administration:cluster:redo")) {
            return this.adminClusterRedo;
        }
        if (permission.equalsIgnoreCase("administration:security:secret")) {
            return this.adminSecuritySecret;
        }
        if (permission.equalsIgnoreCase("administration:security:certificate")) {
            return this.adminSecurityCertificate;
        }
        if (permission.equalsIgnoreCase("administration:cluster:gfs-usage")) {
            return this.adminClusterGfs;
        }
        if (permission.equalsIgnoreCase("administration:cluster:memory-usage")) {
            return this.adminClusterMemory;
        }
        if (permission.equalsIgnoreCase("administration:cluster:configuration")) {
            return this.adminClusterConfig;
        }
        if (permission.equalsIgnoreCase("administration:nodes:configuration")) {
            return this.adminNodesConfig;
        }
        if (permission.equalsIgnoreCase("administration:nodes:commands")) {
            return this.adminNodesCommand;
        }
        if (permission.equalsIgnoreCase("administration:nodes:system")) {
            return this.adminNodesSystem;
        }
        if (permission.equalsIgnoreCase("administration:nodes:queues")) {
            return this.adminNodesQueue;
        }
        if (permission.equalsIgnoreCase("administration:queues:current")) {
            return this.adminQueuesCurrent;
        }
        if (permission.equalsIgnoreCase("administration:queues:statistics")) {
            return this.adminQueuesStats;
        }
        if (permission.equalsIgnoreCase("administration:queues:internalMaps")) {
            return this.adminQueuesInternals;
        }
        if (permission.equalsIgnoreCase("administration:*")) {
            return this.adminAll;
        }
        return null;
    }
}

