/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles.inspector;

import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.ViewStackPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.TreeOptions;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.AdministrationPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.CertificatesPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.GfsPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.JobsPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.NodesPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.ResourcesPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.RolesPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.SwarmPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.permissions.ViewPermissionsPanel;
import org.pepstock.jem.node.security.Role;

public class PermissionsPanel
extends SplitLayoutPanel
implements InspectListener<String>,
ResizeCapable {
    private TreeOptions options = new TreeOptions();
    private ViewStackPanel viewStack = new ViewStackPanel();
    private VerticalPanel center = new VerticalPanel();
    private VerticalPanel west = new VerticalPanel();
    private Role role = null;

    public PermissionsPanel(Role role) {
        this.setRole(role);
        Label headerDomain = new Label("Domains");
        headerDomain.addStyleName(Styles.INSTANCE.common().bold());
        headerDomain.setHeight(Sizes.toString(24));
        this.west.add((Widget)headerDomain);
        this.options.setListener(this);
        this.west.add((Widget)this.options);
        this.addWest((Widget)this.west, 200.0);
        ViewPermissionsPanel viewPanel = new ViewPermissionsPanel(role);
        JobsPermissionsPanel jobsPanel = new JobsPermissionsPanel(role);
        RolesPermissionsPanel rolesPanel = new RolesPermissionsPanel(role);
        NodesPermissionsPanel nodesPanel = new NodesPermissionsPanel(role);
        SwarmPermissionsPanel swarmNodesPanel = new SwarmPermissionsPanel(role);
        ResourcesPermissionsPanel resourcesPanel = new ResourcesPermissionsPanel(role);
        GfsPermissionsPanel gfsPanel = new GfsPermissionsPanel(role);
        AdministrationPermissionsPanel adminPanel = new AdministrationPermissionsPanel(role);
        CertificatesPermissionsPanel certPanel = new CertificatesPermissionsPanel(role);
        this.viewStack.add((Widget)viewPanel);
        this.viewStack.add((Widget)jobsPanel);
        this.viewStack.add((Widget)nodesPanel);
        this.viewStack.add((Widget)swarmNodesPanel);
        this.viewStack.add((Widget)rolesPanel);
        this.viewStack.add((Widget)resourcesPanel);
        this.viewStack.add((Widget)gfsPanel);
        this.viewStack.add((Widget)adminPanel);
        this.viewStack.add((Widget)certPanel);
        this.viewStack.setSpacing(5);
        Label headerPermissions = new Label("Permissions");
        headerPermissions.addStyleName(Styles.INSTANCE.common().bold());
        headerPermissions.addStyleName(Styles.INSTANCE.common().marginLeft20());
        headerPermissions.setHeight(Sizes.toString(24));
        this.center.add((Widget)headerPermissions);
        this.center.add((Widget)this.viewStack);
        this.add((Widget)this.center);
        this.viewStack.showStack(0);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        this.setWidth(Sizes.toString(availableWidth));
        this.setHeight(Sizes.toString(availableHeight));
        int desiredWidth = availableWidth - 200 - 8 - this.viewStack.getSpacing() - this.viewStack.getSpacing();
        int desiredHeight = availableHeight - this.viewStack.getSpacing() - this.viewStack.getSpacing();
        this.options.setSize(Sizes.toString(200), Sizes.toString(desiredHeight -= 24));
        for (Widget w : this.viewStack.getWidgets()) {
            w.setSize(Sizes.toString(desiredWidth), Sizes.toString(desiredHeight));
            if (!(w instanceof ResizeCapable)) continue;
            ((ResizeCapable)w).onResize(desiredWidth, desiredHeight);
        }
    }

    @Override
    public void inspect(String object) {
        if (object.equalsIgnoreCase("views")) {
            this.viewStack.showStack(0);
        } else if (object.equalsIgnoreCase("jobs")) {
            this.viewStack.showStack(1);
        } else if (object.equalsIgnoreCase("nodes")) {
            this.viewStack.showStack(2);
        } else if (object.equalsIgnoreCase("swarm")) {
            this.viewStack.showStack(3);
        } else if (object.equalsIgnoreCase("roles")) {
            this.viewStack.showStack(4);
        } else if (object.equalsIgnoreCase("resources")) {
            this.viewStack.showStack(5);
        } else if (object.equalsIgnoreCase("gfs")) {
            this.viewStack.showStack(6);
        } else if (object.equalsIgnoreCase("admin")) {
            this.viewStack.showStack(7);
        } else if (object.equalsIgnoreCase("certificates")) {
            this.viewStack.showStack(8);
        }
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
    }
}

