/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.Images;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.panels.roles.RolesComparator;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.util.filters.fields.RoleFilterFields;

public class RolesTable
extends AbstractTable<Role> {
    @Override
    public IndexedColumnComparator<Role> initCellTable(CellTable<Role> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<Role, Boolean> checkColumn = new Column<Role, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Role role) {
                return selectionModel.isSelected((Object)role);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (RolesTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (Role r : RolesTable.this.getTable().getVisibleItems()) {
                    if (RolesTable.this.getTable().getSelectionModel().isSelected((Object)r)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (Role r : RolesTable.this.getTable().getVisibleItems()) {
                    RolesTable.this.getTable().getSelectionModel().setSelected((Object)r, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        AnchorTextColumn<Role> name = new AnchorTextColumn<Role>(){

            @Override
            public void onClick(int index, Role object, String value) {
                RolesTable.this.getInspectListener().inspect(object);
            }

            @Override
            public String getValue(Role role) {
                return role.getName();
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", RoleFilterFields.NAME.getName()));
        TextColumn<Role> removable = new TextColumn<Role>(){

            public String getValue(Role role) {
                return String.valueOf(role.isRemovable());
            }
        };
        removable.setSortable(true);
        table.addColumn((Column)removable, (Header)new TextFilterableHeader("Removable", RoleFilterFields.REMOVABLE.getName()));
        TextColumn<Role> permissions = new TextColumn<Role>(){
            private final String imageHtml = AbstractImagePrototype.create((ImageResource)Images.INSTANCE.permission()).getHTML();

            public String getValue(Role role) {
                if (role.getPermissions().isEmpty()) {
                    return "";
                }
                return role.getPermissions().toString();
            }

            public void render(Cell.Context context, Role value, SafeHtmlBuilder sb) {
                if (value == null) {
                    return;
                }
                if (value.getPermissions().isEmpty()) {
                    return;
                }
                sb.appendHtmlConstant("<table>");
                sb.appendHtmlConstant("<tr><td>");
                sb.appendHtmlConstant(this.imageHtml);
                sb.appendHtmlConstant("</td>");
                sb.appendHtmlConstant("<td align='left' valign='middle'> Permissions: <b>");
                sb.appendEscaped(value.getPermissions().toString());
                sb.appendHtmlConstant("</b></td></tr></table>");
            }
        };
        table.addColumn((Column)permissions, (Header)new TextFilterableHeader("Permissions", RoleFilterFields.PERMISSIONS.getName()));
        TextColumn<Role> users = new TextColumn<Role>(){
            private final String imageHtml = AbstractImagePrototype.create((ImageResource)Images.INSTANCE.user()).getHTML();

            public String getValue(Role role) {
                if (role.getUsers().isEmpty()) {
                    return "";
                }
                return role.getUsers().toString();
            }

            public void render(Cell.Context context, Role value, SafeHtmlBuilder sb) {
                if (value == null) {
                    return;
                }
                if (value.getUsers().isEmpty()) {
                    return;
                }
                sb.appendHtmlConstant("<table>");
                sb.appendHtmlConstant("<tr><td>");
                sb.appendHtmlConstant(this.imageHtml);
                sb.appendHtmlConstant("</td>");
                sb.appendHtmlConstant("<td align='left' valign='middle'> Users: <b>");
                sb.appendEscaped(value.getUsers().toString());
                sb.appendHtmlConstant("</b></td></tr></table>");
            }
        };
        table.addColumn((Column)users, (Header)new TextFilterableHeader("Users", RoleFilterFields.USERS.getName()));
        TextColumn<Role> lastModified = new TextColumn<Role>(){

            public String getValue(Role role) {
                if (role.getLastModified() == null) {
                    return "";
                }
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(role.getLastModified());
            }
        };
        lastModified.setSortable(true);
        table.addColumn((Column)lastModified, (Header)new TextFilterableHeader("Modified", RoleFilterFields.MODIFIED.getName(), RoleFilterFields.MODIFIED.getPattern()));
        TextColumn<Role> user = new TextColumn<Role>(){

            public String getValue(Role role) {
                return role.getUser() != null ? role.getUser() : "";
            }
        };
        user.setSortable(true);
        table.addColumn((Column)user, (Header)new TextFilterableHeader("Modified by", RoleFilterFields.MODIFIED_BY.getName()));
        return new RolesComparator(1);
    }
}

