/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.panels.roles.RoleInspector;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.Role;
import org.pepstock.jem.node.security.Roles;

public class RolesActions
extends AbstractActionsButtonPanel<Role> {
    public RolesActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addCreateButton();
        this.addDeleteButton();
        this.addCloneButton();
    }

    private void addCreateButton() {
        if (ClientPermissions.isAuthorized("roles", "roles:create")) {
            Button createButton = new Button("Create new role", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)RolesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    selectionModel.clear();
                    RoleInspector inspector = new RoleInspector();
                    inspector.center();
                    inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> arg0) {
                            RolesActions.this.getSearcher().refresh();
                        }
                    });
                }
            });
            this.add((Widget)createButton);
        }
    }

    private void addDeleteButton() {
        if (ClientPermissions.isAuthorized("roles", "roles:delete")) {
            Button removeButton = new Button("Remove", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)RolesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No role selected!", "No role is selected and it's not possible to perform REMOVE command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm REMOVE", "Are you sure you want to remove the selected roles?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                RolesActions.this.remove(selectionModel.getSelectedSet());
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)removeButton);
        }
    }

    private void addCloneButton() {
        if (ClientPermissions.isAuthorized("roles", "roles:create")) {
            Button cloneButton = new Button("Clone", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)RolesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No role selected!", "No role is selected and it's not possible to perform CLONE command.");
                        alert.open();
                        return;
                    }
                    if (selectionModel.getSelectedSet().size() > 1) {
                        AlertMessageBox alert = new AlertMessageBox(1, "Too many roles selected!", "Only one role must be selected otherwise it's not possible to perform CLONE command.");
                        alert.open();
                        return;
                    }
                    Role source = (Role)selectionModel.getSelectedSet().iterator().next();
                    if (source.getName().equalsIgnoreCase(Roles.ADMINISTRATOR_ROLE.getName())) {
                        selectionModel.clear();
                        AlertMessageBox alert = new AlertMessageBox(2, "'" + Roles.ADMINISTRATOR_ROLE.getName() + "' cannot be cloned!", "'" + Roles.ADMINISTRATOR_ROLE.getName() + "' cannot be cloned. Please creates a new ones and clone that.");
                        alert.open();
                        return;
                    }
                    Role clone = new Role();
                    clone.setPermissions((ArrayList)source.getPermissions().clone());
                    clone.setRemovable(true);
                    clone.setUsers((ArrayList)source.getUsers().clone());
                    selectionModel.clear();
                    RoleInspector inspector = new RoleInspector(clone, 2);
                    inspector.center();
                    inspector.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

                        public void onClose(CloseEvent<PopupPanel> arg0) {
                            RolesActions.this.getSearcher().refresh();
                        }
                    });
                    selectionModel.clear();
                }
            });
            this.add((Widget)cloneButton);
        }
    }

    public void remove(final Collection<Role> roles) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.ROLES_MANAGER.removeRole(roles, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (RolesActions.this.getSearcher() != null) {
                            RolesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Remove role command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        RolesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

