/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.roles;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AbstractTabPanelInspector;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.Loading;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.roles.inspector.Actions;
import org.pepstock.jem.gwt.client.panels.roles.inspector.AdvancedPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.DatasourcePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.FilePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.NewRoleHeader;
import org.pepstock.jem.gwt.client.panels.roles.inspector.PermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.RoleHeader;
import org.pepstock.jem.gwt.client.panels.roles.inspector.SearchPermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.SurrogatePermissionsPanel;
import org.pepstock.jem.gwt.client.panels.roles.inspector.UsersPanel;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.security.Role;

public class RoleInspector
extends AbstractTabPanelInspector {
    private final Loading loading = new Loading();
    public static final int NEW = 0;
    public static final int UPDATE = 1;
    public static final int CLONE = 2;
    private int action = 0;
    private Role role = null;
    private TabPanel mainPanel = new TabPanel();
    private Actions actions = null;

    public RoleInspector() {
        this(new Role(), 0);
        this.getRole().setRemovable(true);
    }

    public RoleInspector(Role role) {
        this(role, 1);
    }

    public RoleInspector(Role role, int action) {
        super(true);
        this.setRole(role);
        this.setAction(action);
        if (role.isRemovable()) {
            this.mainPanel.add((Widget)new PermissionsPanel(role), "Views and Actions");
        }
        if (!role.getPermissions().contains("*")) {
            this.mainPanel.add((Widget)new SearchPermissionsPanel(role), "Searches");
            this.mainPanel.add((Widget)new DatasourcePermissionsPanel(role), "Datasources");
            this.mainPanel.add((Widget)new FilePermissionsPanel(role), "Files");
            this.mainPanel.add((Widget)new SurrogatePermissionsPanel(role), "Surrogate");
            this.mainPanel.add((Widget)new AdvancedPermissionsPanel(role), "Advanced");
        }
        UsersPanel usersPanel = new UsersPanel(role);
        this.mainPanel.add((Widget)usersPanel, "Users");
        this.mainPanel.setWidth("100%");
        this.actions = new Actions(role);
        this.actions.setInspector(this);
        this.mainPanel.selectTab(0);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void cancel() {
        this.hide();
    }

    @Override
    public FlexTable getHeader() {
        if (this.getAction() == 1) {
            return new RoleHeader(this.getRole().getName(), this);
        }
        return new NewRoleHeader(this.getRole(), this);
    }

    @Override
    public TabPanel getTabPanel() {
        return this.mainPanel;
    }

    public CellPanel getActions() {
        return this.actions;
    }

    public void save() {
        if (this.role.getName() != null) {
            if (!this.role.getName().trim().isEmpty()) {
                this.loading.startProcessing();
                Scheduler scheduler = Scheduler.get();
                scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        if (RoleInspector.this.getAction() != 1) {
                            Services.ROLES_MANAGER.addRole(RoleInspector.this.role, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                                @Override
                                public void onJemSuccess(Boolean result) {
                                }

                                @Override
                                public void onJemFailure(Throwable caught) {
                                    AlertMessageBox alert = new AlertMessageBox(2, "Add role command error!", caught.getMessage());
                                    alert.open();
                                }

                                @Override
                                public void onJemExecuted() {
                                    RoleInspector.this.loading.stopProcessing();
                                    RoleInspector.this.hide();
                                }
                            });
                        } else {
                            Services.ROLES_MANAGER.updateRole(RoleInspector.this.role, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                                @Override
                                public void onJemSuccess(Boolean result) {
                                }

                                @Override
                                public void onJemFailure(Throwable caught) {
                                    AlertMessageBox alert = new AlertMessageBox(2, "Update role command error!", caught.getMessage());
                                    alert.open();
                                }

                                @Override
                                public void onJemExecuted() {
                                    RoleInspector.this.loading.stopProcessing();
                                    RoleInspector.this.hide();
                                }
                            });
                        }
                    }
                });
            } else {
                AlertMessageBox alert = new AlertMessageBox(2, "Role name empty!", "Role name is empty. Please type a Role name");
                alert.open();
            }
        } else {
            AlertMessageBox alert = new AlertMessageBox(2, "Invalid role name!", "Please type a valid Role name");
            alert.open();
        }
    }
}

