/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.TextBox;
import java.util.HashMap;
import org.pepstock.jem.gwt.client.commons.MandatoryTextBox;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.AbstractFieldPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.CustomResourcePropertiesPanel;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.node.resources.custom.fields.TextFieldDescriptor;

public class TextFieldPanel
extends AbstractFieldPanel<TextFieldDescriptor, TextBox, String> {
    public TextFieldPanel(TextFieldDescriptor descriptor, CustomResourcePropertiesPanel<?> panel) {
        super(descriptor, panel);
        this.build();
    }

    @Override
    protected void build() {
        this.inputObject = ((TextFieldDescriptor)this.getDescriptor()).isMandatory() ? new MandatoryTextBox() : new TextBox();
        Handler handler = new Handler();
        ((TextBox)this.inputObject).addKeyUpHandler((KeyUpHandler)handler);
        ((TextBox)this.inputObject).addValueChangeHandler((ValueChangeHandler)handler);
        ResourceProperty existingProperty = (ResourceProperty)this.getPanel().getResource().getProperties().get(((TextFieldDescriptor)this.getDescriptor()).getKey());
        if (existingProperty != null) {
            this.setSelectedValue(existingProperty.getValue());
        } else if (((TextFieldDescriptor)this.getDescriptor()).hasDefaultValue()) {
            String defaultValue = ((TextFieldDescriptor)this.getDescriptor()).getDefaultValue();
            this.setSelectedValue(defaultValue);
            this.saveProperty(defaultValue);
        }
    }

    @Override
    public boolean checkMandatory() {
        if (((TextFieldDescriptor)this.getDescriptor()).isMandatory()) {
            MandatoryTextBox mtb = (MandatoryTextBox)this.inputObject;
            return mtb.isCompiled();
        }
        return true;
    }

    @Override
    public void loadProperties() {
        HashMap props = this.getPanel().getResource().getProperties();
        ResourceProperty p = (ResourceProperty)props.get(((TextFieldDescriptor)this.getDescriptor()).getKey());
        if (p != null && p.getValue() != null) {
            ((TextBox)this.inputObject).setText(p.getValue());
        }
    }

    @Override
    public String getSelectedValue() {
        return ((TextBox)this.inputObject).getText();
    }

    @Override
    public void setSelectedValue(String value) {
        ((TextBox)this.inputObject).setValue((Object)value);
    }

    @Override
    public void saveProperty(String value) {
        this.getPanel().getResource().setProperty(((TextFieldDescriptor)this.getDescriptor()).getKey(), value);
        this.setCommonPropertyAttributes();
    }

    @Override
    public boolean validate() {
        String regExValidator = ((TextFieldDescriptor)this.getDescriptor()).getRegExValidator();
        if (regExValidator != null && !regExValidator.trim().isEmpty()) {
            if (this.getSelectedValue().matches(regExValidator)) {
                return true;
            }
        } else {
            return true;
        }
        Toast t = new Toast(1, "The value of '" + this.getLabel() + "' must match the regular expression '" + regExValidator + "'.", "Illegal value");
        t.show();
        return false;
    }

    class Handler
    implements KeyUpHandler,
    ValueChangeHandler<String> {
        Handler() {
        }

        public void onValueChange(ValueChangeEvent<String> event) {
            this.setSelectedAndSave();
        }

        public void onKeyUp(KeyUpEvent event) {
            this.setSelectedAndSave();
        }

        private void setSelectedAndSave() {
            String value = TextFieldPanel.this.getSelectedValue();
            TextFieldPanel.this.saveProperty(value);
        }
    }
}

