/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.AbstractFieldPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.CustomResourcePropertiesPanel;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.node.resources.custom.fields.SingleSelectableListFieldDescriptor;

public class RadioButtonsFieldPanel
extends AbstractFieldPanel<SingleSelectableListFieldDescriptor, Grid, String> {
    protected static int instances = 0;
    protected RadioButton[] buttons = null;

    public RadioButtonsFieldPanel(SingleSelectableListFieldDescriptor descriptor, CustomResourcePropertiesPanel<?> panel) {
        super(descriptor, panel);
        this.build();
    }

    @Override
    protected void build() {
        this.inputObject = new Grid((int)Math.ceil((float)((SingleSelectableListFieldDescriptor)this.getDescriptor()).getValues().size() / 2.0f), 2);
        ((Grid)this.inputObject).setWidth("100%");
        this.buttons = new RadioButton[((SingleSelectableListFieldDescriptor)this.getDescriptor()).getValues().size()];
        String radioButtonGroupName = "RadioButtonGroup-" + ++instances;
        Handler handler = new Handler();
        ArrayList valueList = new ArrayList(((SingleSelectableListFieldDescriptor)this.getDescriptor()).getValues());
        Collections.sort(valueList);
        int i = 0;
        int row = 0;
        for (String v : valueList) {
            RadioButton rb = new RadioButton(radioButtonGroupName, v);
            rb.addValueChangeHandler((ValueChangeHandler)handler);
            this.buttons[i] = rb;
            ((Grid)this.inputObject).setWidget(row, i % 2 == 0 ? 0 : 1, (Widget)rb);
            if (++i % 2 != 0) continue;
            ++row;
        }
        ResourceProperty existingProperty = (ResourceProperty)this.getPanel().getResource().getProperties().get(((SingleSelectableListFieldDescriptor)this.getDescriptor()).getKey());
        if (existingProperty != null) {
            this.setSelectedValue(existingProperty.getValue());
        } else if (((SingleSelectableListFieldDescriptor)this.getDescriptor()).hasDefaultValue()) {
            String defaultValue = ((SingleSelectableListFieldDescriptor)this.getDescriptor()).getDefaultValue();
            this.setSelectedValue(defaultValue);
            this.saveProperty(defaultValue);
        }
    }

    @Override
    public boolean checkMandatory() {
        if (((SingleSelectableListFieldDescriptor)this.getDescriptor()).isMandatory()) {
            for (RadioButton rb : this.buttons) {
                if (!rb.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void loadProperties() {
        HashMap props = this.getPanel().getResource().getProperties();
        ResourceProperty p = (ResourceProperty)props.get(((SingleSelectableListFieldDescriptor)this.getDescriptor()).getKey());
        if (p != null && p.getValue() != null) {
            this.setSelectedValue(p.getValue());
        }
    }

    @Override
    public String getSelectedValue() {
        for (RadioButton rb : this.buttons) {
            if (!rb.getValue().booleanValue()) continue;
            return rb.getText();
        }
        return null;
    }

    @Override
    public void setSelectedValue(String value) {
        for (RadioButton rb : this.buttons) {
            if (!rb.getText().equals(value)) continue;
            rb.setValue(Boolean.valueOf(true));
            break;
        }
    }

    @Override
    public void saveProperty(String value) {
        String key = ((SingleSelectableListFieldDescriptor)this.getDescriptor()).getKey();
        this.getPanel().getResource().setProperty(key, value);
        this.setCommonPropertyAttributes();
    }

    class Handler
    implements ValueChangeHandler<Boolean> {
        Handler() {
        }

        public void onValueChange(ValueChangeEvent<Boolean> event) {
            String value = RadioButtonsFieldPanel.this.getSelectedValue();
            RadioButtonsFieldPanel.this.saveProperty(value);
        }
    }
}

