/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import java.util.LinkedList;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.AbstractFieldPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.CustomResourcePropertiesPanel;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.custom.SectionDescriptor;

public class PagePropertiesPanel
extends CustomResourcePropertiesPanel<SectionDescriptor> {
    protected LinkedList<AbstractFieldPanel<?, ?, ?>> fields = new LinkedList();
    protected boolean stylized = false;
    protected String resourceType = null;

    public PagePropertiesPanel(Resource resource, SectionDescriptor descriptor) {
        this(resource, descriptor, null);
    }

    public PagePropertiesPanel(Resource resource, SectionDescriptor descriptor, String resourceType) {
        super(resource, descriptor, false);
        this.resourceType = resourceType;
        this.getTable().setSize("100%", "100%");
        this.getTable().setCellSpacing(5);
    }

    @Override
    public boolean checkMandatory() {
        boolean result = true;
        for (int i = 0; i < this.fields.size() && result; result &= this.fields.get(i).checkMandatory(), ++i) {
        }
        return result;
    }

    @Override
    public boolean validate() {
        boolean result = true;
        for (int i = 0; i < this.fields.size() && result; result &= this.fields.get(i).validate(), ++i) {
        }
        return result;
    }

    @Override
    public void loadProperties() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).loadProperties();
        }
    }

    public void addFieldPanel(AbstractFieldPanel<?, ?, ?> fieldPanel) {
        this.fields.add(fieldPanel);
        int row = this.getTable().getRowCount();
        this.getTable().setHTML(row, 0, fieldPanel.getLabel());
        this.getTable().setWidget(row, 1, fieldPanel.getInputObject());
        this.getTable().setHTML(row, 2, fieldPanel.getDescription());
        this.stylize();
    }

    protected void stylize() {
        if (!this.stylized) {
            this.getTable().getColumnFormatter().addStyleName(0, Styles.INSTANCE.common().noWrap());
            this.getTable().getColumnFormatter().setWidth(0, "15%");
            this.getTable().getColumnFormatter().setWidth(1, "45%");
            this.getTable().getColumnFormatter().setWidth(2, "40%");
            this.stylized = true;
        }
    }

    @Override
    public void initializeResource() {
        if (this.resourceType != null && !this.resourceType.trim().isEmpty()) {
            this.getResource().setType(this.resourceType);
        }
    }
}

