/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import java.util.HashMap;
import java.util.Set;
import org.pepstock.jem.gwt.client.commons.CSVUtil;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.AbstractFieldPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.ListEditor;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.ListEditorListener;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.PagePropertiesPanel;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.node.resources.custom.fields.TextListFieldDescriptor;

public class ListFieldPanel
extends AbstractFieldPanel<TextListFieldDescriptor, ListEditor, String[]>
implements ListEditorListener<String[]> {
    public ListFieldPanel(TextListFieldDescriptor descriptor, PagePropertiesPanel panel) {
        super(descriptor, panel);
        this.build();
    }

    @Override
    protected void build() {
        this.inputObject = new ListEditor(((TextListFieldDescriptor)this.getDescriptor()).getInputLabel(), "Values", ((TextListFieldDescriptor)this.getDescriptor()).getRegExValidator());
        ((ListEditor)this.inputObject).setSize("100%", "100%");
        ResourceProperty existingProperty = (ResourceProperty)this.getPanel().getResource().getProperties().get(((TextListFieldDescriptor)this.getDescriptor()).getKey());
        if (existingProperty == null && ((TextListFieldDescriptor)this.getDescriptor()).hasDefaultValues()) {
            Set defaultValue = ((TextListFieldDescriptor)this.getDescriptor()).getDefaultValues();
            String[] defaultValueArray = defaultValue.toArray(new String[0]);
            this.setSelectedValue(defaultValueArray);
            this.saveProperty(defaultValueArray);
        }
        ((ListEditor)this.inputObject).setListener(this);
    }

    @Override
    public boolean checkMandatory() {
        if (((TextListFieldDescriptor)this.getDescriptor()).isMandatory()) {
            return ((ListEditor)this.inputObject).getValues().length > 0;
        }
        return true;
    }

    @Override
    public boolean validate() {
        boolean allMatch = true;
        String regExValidator = ((TextListFieldDescriptor)this.getDescriptor()).getRegExValidator();
        String notMatchingValue = null;
        if (regExValidator != null && !regExValidator.trim().isEmpty()) {
            try {
                for (String currentValue : this.getSelectedValue()) {
                    if (currentValue.matches(regExValidator)) {
                        allMatch &= true;
                        continue;
                    }
                    notMatchingValue = currentValue;
                    allMatch = false;
                    break;
                }
            }
            catch (Exception pse) {
                Toast t = new Toast(2, "Unable to parse regular expression '" + regExValidator + "'. Check the Resource Descriptor.", "Validator error");
                t.show();
                return false;
            }
        }
        if (allMatch) {
            return true;
        }
        Toast t = new Toast(1, "The value '" + notMatchingValue + "' in list must match the regular expression '" + regExValidator + "'.", "Illegal value");
        t.show();
        return false;
    }

    @Override
    public void loadProperties() {
        HashMap props = this.getPanel().getResource().getProperties();
        ResourceProperty p = (ResourceProperty)props.get(((TextListFieldDescriptor)this.getDescriptor()).getKey());
        if (p != null && p.getValue() != null) {
            String[] toBeSelectedValues = CSVUtil.split(p.getValue());
            this.setSelectedValue(toBeSelectedValues);
        }
    }

    @Override
    public String[] getSelectedValue() {
        return ((ListEditor)this.inputObject).getValues();
    }

    @Override
    public void setSelectedValue(String[] value) {
        ((ListEditor)this.inputObject).setValues(value);
    }

    @Override
    public void valuesChanged(String[] newValues) {
        this.saveProperty(newValues);
    }

    @Override
    public void saveProperty(String[] value) {
        String key = ((TextListFieldDescriptor)this.getDescriptor()).getKey();
        String csv = CSVUtil.getCSVPhrase(value);
        this.getPanel().getResource().setProperty(key, csv);
        this.setCommonPropertyAttributes();
    }
}

