/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.pepstock.jem.gwt.client.ResizeCapable;
import org.pepstock.jem.gwt.client.Sizes;
import org.pepstock.jem.gwt.client.commons.CellTableStyle;
import org.pepstock.jem.gwt.client.commons.InspectListener;
import org.pepstock.jem.gwt.client.commons.Styles;
import org.pepstock.jem.gwt.client.commons.Toast;
import org.pepstock.jem.gwt.client.panels.components.RemovePanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.ListEditorListener;
import org.pepstock.jem.gwt.client.panels.roles.inspector.commons.InputPanel;

public class ListEditor
extends HorizontalPanel
implements InspectListener<String>,
ClickHandler,
ResizeCapable {
    private InputPanel inputPanel = null;
    private VerticalPanel listContainer = new VerticalPanel();
    private VerticalPanel scrollHolder = new VerticalPanel();
    private Label label = new Label();
    private ScrollPanel scrollPanel = new ScrollPanel();
    private CellList<String> cellList = new CellList((Cell)new TextCell(), (CellList.Resources)GWT.create(CellTableStyle.class));
    private RemovePanel removePanel = new RemovePanel();
    private final SingleSelectionModel<String> selectionModel = new SingleSelectionModel();
    private List<String> values = new ArrayList<String>();
    private ListEditorListener<String[]> listener = null;
    private String regExValidator = null;

    public ListEditor(String inputPanelHeader, String listHeader, String regExValidator) {
        this.regExValidator = regExValidator;
        this.inputPanel = new InputPanel(inputPanelHeader);
        this.inputPanel.setListener(this);
        this.cellList.setSize("100%", "100%");
        this.cellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.cellList.setSelectionModel(this.selectionModel);
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                if (ListEditor.this.selectionModel.getSelectedObject() != null) {
                    ListEditor.this.removePanel.setEnabled(true);
                }
            }
        });
        this.scrollHolder.setSize("100%", "100%");
        this.scrollHolder.addStyleName(Styles.INSTANCE.administration().nodeList());
        this.scrollHolder.add((Widget)this.scrollPanel);
        this.scrollPanel.setWidget(this.cellList);
        this.listContainer.setSize("100%", "100%");
        this.listContainer.setSpacing(5);
        this.label.setText(listHeader);
        this.label.addStyleName(Styles.INSTANCE.common().bold());
        this.label.setHeight(Sizes.toString(24));
        this.listContainer.add((Widget)this.label);
        this.listContainer.add((Widget)this.scrollHolder);
        this.listContainer.setCellHeight((Widget)this.scrollHolder, "100%");
        this.removePanel.setClickHandler(this);
        this.add((Widget)this.inputPanel);
        this.add((Widget)this.listContainer);
        this.add((Widget)this.removePanel);
        this.setCellWidth((Widget)this.listContainer, "100%");
        this.setCellHeight((Widget)this.listContainer, "100%");
    }

    public String[] getValues() {
        return this.values.toArray(new String[0]);
    }

    public void setValues(String[] values) {
        if (values != null) {
            this.clearUI();
            ArrayList<String> valueList = new ArrayList<String>();
            for (String v : values) {
                valueList.add(v);
            }
            while (valueList.contains("")) {
                valueList.remove("");
            }
            this.values.addAll(valueList);
            this.renderList();
            this.inputPanel.clear();
            if (this.listener != null) {
                this.listener.valuesChanged(this.getValues());
            }
        }
    }

    private void addValue(String newValue) {
        if (this.validate(newValue)) {
            if (!this.values.contains(newValue)) {
                this.values.add(newValue);
                this.renderList();
                this.inputPanel.clear();
                if (this.listener != null) {
                    this.listener.valuesChanged(this.getValues());
                }
            }
        } else {
            Toast t = new Toast(1, "The value '" + newValue + "' must match the regular expression '" + this.regExValidator + "'.", "Illegal value");
            t.show();
        }
    }

    private boolean validate(String value) {
        boolean toReturn;
        if (this.regExValidator != null && !this.regExValidator.trim().isEmpty()) {
            try {
                toReturn = value.matches(this.regExValidator);
            }
            catch (Exception e) {
                toReturn = false;
                Toast t = new Toast(2, "Unable to parse regular expression '" + this.regExValidator + "'. Check the Resource Descriptor.", "Validator error");
                t.show();
            }
        } else {
            toReturn = true;
        }
        return toReturn;
    }

    private void removeValue(String value) {
        this.values.remove(value);
        this.renderList();
        this.removePanel.setEnabled(false);
        if (this.listener != null) {
            this.listener.valuesChanged(this.getValues());
        }
    }

    protected void clearUI() {
        this.values.clear();
        this.renderList();
        this.inputPanel.clear();
        this.removePanel.setEnabled(false);
    }

    private void renderList() {
        this.cellList.setRowCount(this.values.size(), true);
        this.cellList.setRowData(0, this.values);
    }

    public void onClick(ClickEvent event) {
        String selected = (String)this.selectionModel.getSelectedObject();
        this.removeValue(selected);
    }

    @Override
    public void inspect(String object) {
        this.addValue(object);
    }

    public ListEditorListener<String[]> getListener() {
        return this.listener;
    }

    public void setListener(ListEditorListener<String[]> listener) {
        this.listener = listener;
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        int newAvailableHeight = availableHeight - 6 * this.listContainer.getSpacing() - this.label.getOffsetHeight();
        this.scrollPanel.setHeight(Sizes.toString(newAvailableHeight));
    }

    static {
        Styles.INSTANCE.common().ensureInjected();
        Styles.INSTANCE.administration().ensureInjected();
    }
}

