/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector.custom;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pepstock.jem.gwt.client.commons.CSVUtil;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.AbstractFieldPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.custom.CustomResourcePropertiesPanel;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.node.resources.custom.fields.MultiSelectableListFieldDescriptor;

public class CheckBoxesFieldPanel
extends AbstractFieldPanel<MultiSelectableListFieldDescriptor, Grid, String[]> {
    protected CheckBox[] checkBoxes = null;

    public CheckBoxesFieldPanel(MultiSelectableListFieldDescriptor descriptor, CustomResourcePropertiesPanel<?> panel) {
        super(descriptor, panel);
        this.build();
    }

    @Override
    protected void build() {
        this.inputObject = new Grid((int)Math.ceil((float)((MultiSelectableListFieldDescriptor)this.getDescriptor()).getValues().size() / 2.0f), 2);
        ((Grid)this.inputObject).setWidth("100%");
        this.checkBoxes = new CheckBox[((MultiSelectableListFieldDescriptor)this.getDescriptor()).getValues().size()];
        Handler handler = new Handler();
        ArrayList valueList = new ArrayList(((MultiSelectableListFieldDescriptor)this.getDescriptor()).getValues());
        Collections.sort(valueList);
        int i = 0;
        int row = 0;
        for (String v : valueList) {
            CheckBox cb = new CheckBox(v);
            cb.addValueChangeHandler((ValueChangeHandler)handler);
            this.checkBoxes[i] = cb;
            ((Grid)this.inputObject).setWidget(row, i % 2 == 0 ? 0 : 1, (Widget)cb);
            if (++i % 2 != 0) continue;
            ++row;
        }
        ResourceProperty existingProperty = (ResourceProperty)this.getPanel().getResource().getProperties().get(((MultiSelectableListFieldDescriptor)this.getDescriptor()).getKey());
        if (existingProperty != null) {
            this.setSelectedValue(CSVUtil.splitAndTrim(existingProperty.getValue()));
        } else if (((MultiSelectableListFieldDescriptor)this.getDescriptor()).hasDefaultValues()) {
            Set defaultValue = ((MultiSelectableListFieldDescriptor)this.getDescriptor()).getDefaultValues();
            String[] defaultValueArray = defaultValue.toArray(new String[0]);
            this.setSelectedValue(defaultValueArray);
            this.saveProperty(defaultValueArray);
        }
    }

    @Override
    public boolean checkMandatory() {
        if (((MultiSelectableListFieldDescriptor)this.getDescriptor()).isMandatory()) {
            for (CheckBox cb : this.checkBoxes) {
                if (!cb.getValue().booleanValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void loadProperties() {
        HashMap props = this.getPanel().getResource().getProperties();
        ResourceProperty p = (ResourceProperty)props.get(((MultiSelectableListFieldDescriptor)this.getDescriptor()).getKey());
        if (p != null && p.getValue() != null) {
            String[] toBeSelectedValues = CSVUtil.split(p.getValue());
            this.setSelectedValue(toBeSelectedValues);
        }
    }

    @Override
    public String[] getSelectedValue() {
        HashSet<String> selected = new HashSet<String>();
        for (CheckBox cb : this.checkBoxes) {
            if (!cb.getValue().booleanValue()) continue;
            selected.add(cb.getText());
        }
        return selected.toArray(new String[0]);
    }

    @Override
    public void setSelectedValue(String[] value) {
        List<String> toBeSelectedTexts = Arrays.asList(value);
        for (CheckBox cb : this.checkBoxes) {
            if (toBeSelectedTexts.contains(cb.getText())) {
                cb.setValue(Boolean.valueOf(true));
                continue;
            }
            cb.setValue(Boolean.valueOf(false));
        }
    }

    @Override
    public void saveProperty(String[] value) {
        String key = ((MultiSelectableListFieldDescriptor)this.getDescriptor()).getKey();
        this.getPanel().getResource().setProperty(key, CSVUtil.getCSVPhrase(value));
        this.setCommonPropertyAttributes();
    }

    @Override
    public boolean validate() {
        return true;
    }

    class Handler
    implements ValueChangeHandler<Boolean> {
        Handler() {
        }

        public void onValueChange(ValueChangeEvent<Boolean> event) {
            String[] value = CheckBoxesFieldPanel.this.getSelectedValue();
            CheckBoxesFieldPanel.this.saveProperty(value);
        }
    }
}

