/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.CSVUtil;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.gwt.client.panels.resources.inspector.jppf.NetworkEditConfig;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;

public class JPPFAttributesPanel
extends ResourcesPropertiesPanel {
    private NetworkEditConfig config = null;
    private ArrayList<String> list = new ArrayList();

    public JPPFAttributesPanel(Resource resource) {
        super(resource, true);
        this.loadProperties();
        this.config = new NetworkEditConfig(this.list);
        this.add((Widget)this.config);
    }

    @Override
    public void loadProperties() {
        for (ResourceProperty property : this.getResource().getProperties().values()) {
            String[] addresses;
            if (!property.getName().equalsIgnoreCase("addresses") || (addresses = CSVUtil.splitAndTrim(property.getValue())) == null) continue;
            for (int i = 0; i < addresses.length; ++i) {
                this.list.add(addresses[i]);
            }
        }
    }

    @Override
    public boolean checkMandatory() {
        if (this.list.isEmpty()) {
            AlertMessageBox alert = new AlertMessageBox(2, "No address", "No address has been defined. You must define one address at least.");
            alert.open();
            return false;
        }
        this.setPropertyValue("addresses", CSVUtil.getCSVPhrase(this.list));
        return true;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void initializeResource() {
        this.getResource().setType("jppf");
    }

    @Override
    public void onResize(int availableWidth, int availableHeight) {
        super.onResize(availableWidth, availableHeight);
        this.config.onResize(availableWidth, availableHeight);
    }
}

