/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.MandatoryTextBox;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;

public class JMSAttributesPanel
extends ResourcesPropertiesPanel {
    private static String NO_REQUIRED_FIELD = "JMS Required Attribute empty!";
    private static String NO_PROVIDER_URL_DESCRIPTION = "JMS provider URL is empty. <br/>Please type a JMS provider URL.";
    private static String NO_INITIAL_CONTEXT_FACTORY_DESCRIPTION = "JMS Initial Context Factory is empty. <br/>Please type a JMS Initial Context Factory.";
    private static String NO_CONNECTION_FACTORY_NAME_DESCRIPTION = "JMS Connection Factory Name is empty. <br/>Please type a <br/>JMS Connection Factory Name.";
    private MandatoryTextBox providerUrl = new MandatoryTextBox();
    private MandatoryTextBox initialContextFactory = new MandatoryTextBox();
    private MandatoryTextBox connectionFactoryName = new MandatoryTextBox();
    private TextBox userid = new TextBox();
    private PasswordTextBox password = new PasswordTextBox();

    public JMSAttributesPanel(Resource resource) {
        super(resource);
        FlexTable table = this.getTable();
        this.setWidth("100%");
        table.setCellPadding(5);
        table.setHTML(0, 0, "JMS Provider URL: <font color=\"red\"><b>*</b></font>");
        table.setWidget(0, 1, (Widget)this.providerUrl);
        table.setHTML(0, 2, "The JMS provider URL in the form: <code>&lt;scheme&gt;://&lt;host&gt;:&lt;port&gt;</code>");
        table.setHTML(1, 0, "JMS Initial Context Factory: <font color=\"red\"><b>*</b></font>");
        table.setWidget(1, 1, (Widget)this.initialContextFactory);
        table.setHTML(1, 2, "The JMS Initial Context Factory to create the connection to use <code>JMS</code>");
        table.setHTML(2, 0, "JMS Connection Factory Name: <font color=\"red\"><b>*</b></font>");
        table.setWidget(2, 1, (Widget)this.connectionFactoryName);
        table.setHTML(2, 2, "The JMS Connection Factory Name to create the connection to use <code>JMS Queue</code> or <code>Topic</code>");
        table.setHTML(3, 0, "User ID:");
        table.setWidget(3, 1, (Widget)this.userid);
        table.setHTML(3, 2, " The JMS security principal on whose behalf the connection is being made");
        table.setHTML(4, 0, "Password:");
        table.setWidget(4, 1, (Widget)this.password);
        table.setHTML(4, 2, " The JMS security credentials");
        table.setHTML(5, 0, "<font color=\"red\"><b>*</b></font> Mandatory.");
        FlexTable.FlexCellFormatter cf = table.getFlexCellFormatter();
        cf.setWordWrap(0, 0, false);
        cf.setWordWrap(1, 0, false);
        cf.setWordWrap(2, 0, false);
        cf.setWordWrap(3, 0, false);
        cf.setWordWrap(4, 0, false);
        this.loadProperties();
        this.providerUrl.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("java.naming.provider.url", JMSAttributesPanel.this.providerUrl.getText());
            }
        });
        this.providerUrl.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                JMSAttributesPanel.this.setPropertyValue("java.naming.provider.url", JMSAttributesPanel.this.providerUrl.getText());
            }
        });
        this.initialContextFactory.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("java.naming.factory.initial", JMSAttributesPanel.this.initialContextFactory.getText());
            }
        });
        this.initialContextFactory.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                JMSAttributesPanel.this.setPropertyValue("java.naming.factory.initial", JMSAttributesPanel.this.initialContextFactory.getText());
            }
        });
        this.connectionFactoryName.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("connectionFactoryName", JMSAttributesPanel.this.connectionFactoryName.getText());
            }
        });
        this.connectionFactoryName.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                JMSAttributesPanel.this.setPropertyValue("connectionFactoryName", JMSAttributesPanel.this.connectionFactoryName.getText());
            }
        });
        this.userid.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("username", JMSAttributesPanel.this.userid.getText());
            }
        });
        this.userid.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                JMSAttributesPanel.this.setPropertyValue("username", JMSAttributesPanel.this.userid.getText());
            }
        });
        this.password.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("password", JMSAttributesPanel.this.password.getText()).setVisible(false);
            }
        });
        this.password.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                JMSAttributesPanel.this.setPropertyValue("username", JMSAttributesPanel.this.userid.getText());
            }
        });
    }

    @Override
    public void loadProperties() {
        for (ResourceProperty property : this.getResource().getProperties().values()) {
            if (property.getName().equalsIgnoreCase("java.naming.provider.url")) {
                this.providerUrl.setText(property.getValue());
                continue;
            }
            if (property.getName().equalsIgnoreCase("java.naming.factory.initial")) {
                this.initialContextFactory.setText(property.getValue());
                continue;
            }
            if (property.getName().equalsIgnoreCase("connectionFactoryName")) {
                this.connectionFactoryName.setText(property.getValue());
                continue;
            }
            if (property.getName().equalsIgnoreCase("username")) {
                this.userid.setText(property.getValue());
                continue;
            }
            if (!property.getName().equalsIgnoreCase("password")) continue;
            this.password.setText(property.getValue());
        }
    }

    @Override
    public boolean checkMandatory() {
        String description = "";
        if (null == this.providerUrl.getText() || this.providerUrl.getText().trim().equals("")) {
            description = "<li>" + NO_PROVIDER_URL_DESCRIPTION + "</li>";
        }
        if (null == this.initialContextFactory.getText() || this.initialContextFactory.getText().trim().equals("")) {
            description = description + "<li>" + NO_INITIAL_CONTEXT_FACTORY_DESCRIPTION + "</li>";
        }
        if (null == this.connectionFactoryName.getText() || this.connectionFactoryName.getText().trim().equals("")) {
            description = description + "<li>" + NO_CONNECTION_FACTORY_NAME_DESCRIPTION + "</li>";
        }
        if (!description.equals("")) {
            AlertMessageBox alert = new AlertMessageBox(2, NO_REQUIRED_FIELD, "<ul>" + description + "</ul>");
            alert.open();
            return false;
        }
        return true;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void initializeResource() {
        this.getResource().setType("jms");
    }
}

