/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources.inspector;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.MandatoryPasswordTextBox;
import org.pepstock.jem.gwt.client.commons.MandatoryTextBox;
import org.pepstock.jem.gwt.client.panels.resources.inspector.ResourcesPropertiesPanel;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;

public class FTPAttributesPanel
extends ResourcesPropertiesPanel {
    private static String NO_REQUIRED_FIELD = "FTP Required Attribute empty!";
    private static String NO_URL_DESCRIPTION = "URL is empty. <br/>Please type a URL.";
    private static String NO_USERID_DESCRIPTION = "USERID is empty. <br/>Please type a USERID.";
    private static String NO_PASSWORD_DESCRIPTION = "PASSWORD is empty. <br/>Please type a PASSWORD.";
    private MandatoryTextBox url = new MandatoryTextBox();
    private MandatoryTextBox userid = new MandatoryTextBox();
    private MandatoryPasswordTextBox password = new MandatoryPasswordTextBox();
    private CheckBox binary = new CheckBox();

    public FTPAttributesPanel(Resource resource) {
        super(resource);
        FlexTable table = this.getTable();
        this.setWidth("100%");
        table.setCellPadding(5);
        table.setHTML(1, 0, "URL: <font color=\"red\"><b>*</b></font>");
        table.setWidget(1, 1, (Widget)this.url);
        table.setHTML(1, 2, "The FTP server URL of the form <code>&lt;scheme&gt;://&lt;authority&gt;</code>");
        table.setHTML(2, 0, "User ID: <font color=\"red\"><b>*</b></font>");
        table.setWidget(2, 1, (Widget)this.userid);
        table.setHTML(2, 2, " the FTP server user on whose behalf the connection is being made");
        table.setHTML(3, 0, "Password: <font color=\"red\"><b>*</b></font>");
        table.setWidget(3, 1, (Widget)this.password);
        table.setHTML(3, 2, " the user's password");
        table.setHTML(4, 0, "Binary file type:");
        table.setWidget(4, 1, (Widget)this.binary);
        table.setHTML(4, 2, "Sets the file type to be transferred to BINARY, otherwise is ASCII");
        table.setHTML(5, 0, "<font color=\"red\"><b>*</b></font> Mandatory.");
        FlexTable.FlexCellFormatter cf = table.getFlexCellFormatter();
        cf.setWordWrap(0, 0, false);
        cf.setWordWrap(1, 0, false);
        cf.setWordWrap(2, 0, false);
        cf.setWordWrap(3, 0, false);
        cf.setWordWrap(4, 0, false);
        this.loadProperties();
        this.url.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                FTPAttributesPanel.this.setPropertyValue("url", FTPAttributesPanel.this.url.getText());
            }
        });
        this.url.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                FTPAttributesPanel.this.setPropertyValue("url", FTPAttributesPanel.this.url.getText());
            }
        });
        this.userid.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                FTPAttributesPanel.this.setPropertyValue("username", FTPAttributesPanel.this.userid.getText());
            }
        });
        this.userid.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                FTPAttributesPanel.this.setPropertyValue("username", FTPAttributesPanel.this.userid.getText());
            }
        });
        this.password.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                FTPAttributesPanel.this.setPropertyValue("password", FTPAttributesPanel.this.password.getText()).setVisible(false);
            }
        });
        this.password.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                FTPAttributesPanel.this.setPropertyValue("password", FTPAttributesPanel.this.password.getText()).setVisible(false);
            }
        });
        this.binary.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                FTPAttributesPanel.this.setPropertyValue("binary", String.valueOf(FTPAttributesPanel.this.binary.getValue()));
            }
        });
    }

    @Override
    public void loadProperties() {
        for (ResourceProperty property : this.getResource().getProperties().values()) {
            if (property.getName().equalsIgnoreCase("url")) {
                this.url.setText(property.getValue());
                continue;
            }
            if (property.getName().equalsIgnoreCase("username")) {
                this.userid.setText(property.getValue());
                continue;
            }
            if (property.getName().equalsIgnoreCase("password")) {
                this.password.setText(property.getValue());
                continue;
            }
            if (!property.getName().equalsIgnoreCase("binary")) continue;
            this.binary.setValue(Boolean.valueOf(property.getValue().equalsIgnoreCase("true")));
        }
    }

    @Override
    public boolean checkMandatory() {
        String description = "";
        if (null == this.url.getText() || this.url.getText().trim().equals("")) {
            description = description + "<li>" + NO_URL_DESCRIPTION + "</li>";
        }
        if (null == this.userid.getText() || this.userid.getText().trim().equals("")) {
            description = description + "<li>" + NO_USERID_DESCRIPTION + "</li>";
        }
        if (null == this.password.getText() || this.password.getText().trim().equals("")) {
            description = description + "<li>" + NO_PASSWORD_DESCRIPTION + "</li>";
        }
        if (!description.equals("")) {
            AlertMessageBox alert = new AlertMessageBox(2, NO_REQUIRED_FIELD, "<ul>" + description + "</ul>");
            alert.open();
            return false;
        }
        return true;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void initializeResource() {
        this.getResource().setType("ftp");
    }
}

