/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.view.client.SelectionModel;
import org.pepstock.jem.gwt.client.commons.AbstractTable;
import org.pepstock.jem.gwt.client.commons.AnchorTextColumn;
import org.pepstock.jem.gwt.client.commons.IndexedColumnComparator;
import org.pepstock.jem.gwt.client.commons.TextFilterableHeader;
import org.pepstock.jem.gwt.client.panels.resources.ResourcesComparator;
import org.pepstock.jem.node.resources.Resource;
import org.pepstock.jem.node.resources.ResourceProperty;
import org.pepstock.jem.util.filters.fields.ResourceFilterFields;

public class ResourcesTable
extends AbstractTable<Resource> {
    @Override
    public IndexedColumnComparator<Resource> initCellTable(CellTable<Resource> table) {
        final SelectionModel selectionModel = table.getSelectionModel();
        Column<Resource, Boolean> checkColumn = new Column<Resource, Boolean>((Cell)new CheckboxCell(true, false)){

            public Boolean getValue(Resource role) {
                return selectionModel.isSelected((Object)role);
            }
        };
        CheckboxCell headerCheckBox = new CheckboxCell(true, false);
        Header<Boolean> checkHeader = new Header<Boolean>((Cell)headerCheckBox){

            public Boolean getValue() {
                if (ResourcesTable.this.getTable().getVisibleItems().isEmpty()) {
                    return false;
                }
                for (Resource r : ResourcesTable.this.getTable().getVisibleItems()) {
                    if (ResourcesTable.this.getTable().getSelectionModel().isSelected((Object)r)) continue;
                    return false;
                }
                return true;
            }
        };
        checkHeader.setUpdater((ValueUpdater)new ValueUpdater<Boolean>(){

            public void update(Boolean value) {
                for (Resource r : ResourcesTable.this.getTable().getVisibleItems()) {
                    ResourcesTable.this.getTable().getSelectionModel().setSelected((Object)r, value.booleanValue());
                }
            }
        });
        table.setColumnWidth((Column)checkColumn, 23.0, Style.Unit.PX);
        table.addColumn((Column)checkColumn, (Header)checkHeader);
        AnchorTextColumn<Resource> name = new AnchorTextColumn<Resource>(){

            @Override
            public void onClick(int index, Resource object, String value) {
                ResourcesTable.this.getInspectListener().inspect(object);
            }

            @Override
            public String getValue(Resource resource) {
                return resource.getName();
            }
        };
        name.setSortable(true);
        table.addColumn((Column)name, (Header)new TextFilterableHeader("Name", ResourceFilterFields.NAME.getName()));
        TextColumn<Resource> type = new TextColumn<Resource>(){

            public String getValue(Resource resource) {
                return resource.getType();
            }
        };
        type.setSortable(true);
        table.addColumn((Column)type, (Header)new TextFilterableHeader("Type", ResourceFilterFields.TYPE.getName()));
        TextColumn<Resource> attributes = new TextColumn<Resource>(){

            public String getValue(Resource resource) {
                int count = 0;
                String value = null;
                for (ResourceProperty property : resource.getProperties().values()) {
                    value = count == 0 ? property.getName() + " = " + (property.isVisible() ? property.getValue() : "***") : value + ", " + property.getName() + " = " + (property.isVisible() ? property.getValue() : "***");
                    ++count;
                }
                return value;
            }

            public void render(Cell.Context context, Resource resource, SafeHtmlBuilder sb) {
                if (resource == null) {
                    return;
                }
                sb.appendHtmlConstant("<code>" + this.getValue(resource) + "</code>");
            }
        };
        table.addColumn((Column)attributes, (Header)new TextFilterableHeader("Properties", ResourceFilterFields.PROPERTIES.getName()));
        TextColumn<Resource> lastModified = new TextColumn<Resource>(){

            public String getValue(Resource resource) {
                if (resource.getLastModified() == null) {
                    return "";
                }
                DateTimeFormat dtf = DateTimeFormat.getFormat((String)"yyyy-MM-dd HH:mm:ss");
                return dtf.format(resource.getLastModified());
            }
        };
        lastModified.setSortable(true);
        table.addColumn((Column)lastModified, (Header)new TextFilterableHeader("Modified", ResourceFilterFields.MODIFIED.getName(), ResourceFilterFields.MODIFIED.getPattern()));
        TextColumn<Resource> user = new TextColumn<Resource>(){

            public String getValue(Resource resource) {
                return resource.getUser() != null ? resource.getUser() : "";
            }
        };
        user.setSortable(true);
        table.addColumn((Column)user, (Header)new TextFilterableHeader("Modified by", ResourceFilterFields.MODIFIED_BY.getName()));
        return new ResourcesComparator(1);
    }
}

