/*
 * Decompiled with CFR 0.152.
 */
package org.pepstock.jem.gwt.client.panels.resources;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import java.util.Collection;
import java.util.HashMap;
import org.pepstock.jem.gwt.client.commons.AlertMessageBox;
import org.pepstock.jem.gwt.client.commons.ConfirmMessageBox;
import org.pepstock.jem.gwt.client.commons.HideHandler;
import org.pepstock.jem.gwt.client.commons.PreferredButton;
import org.pepstock.jem.gwt.client.commons.ServiceAsyncCallback;
import org.pepstock.jem.gwt.client.panels.components.AbstractActionsButtonPanel;
import org.pepstock.jem.gwt.client.panels.resources.CloneResourceInspector;
import org.pepstock.jem.gwt.client.panels.resources.NewResourceInspector;
import org.pepstock.jem.gwt.client.security.ClientPermissions;
import org.pepstock.jem.gwt.client.services.Services;
import org.pepstock.jem.node.resources.Resource;

public class ResourcesActions
extends AbstractActionsButtonPanel<Resource> {
    public ResourcesActions() {
        this.init();
    }

    @Override
    protected void initButtons() {
        this.addCreateButton();
        this.addRemoveButton();
        this.addCloneButton();
    }

    private void addCreateButton() {
        if (ClientPermissions.isAuthorized("resources", "resources:create")) {
            Button createButton = new Button("Create new resource", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)ResourcesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    selectionModel.clear();
                    NewResourceInspector inspector = new NewResourceInspector();
                    inspector.center();
                }
            });
            this.add((Widget)createButton);
        }
    }

    private void addRemoveButton() {
        if (ClientPermissions.isAuthorized("resources", "resources:delete")) {
            Button removeButton = new Button("Remove", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    final MultiSelectionModel selectionModel = (MultiSelectionModel)ResourcesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No resource selected!", "No resource is selected and it's not possible to perform REMOVE command.");
                        alert.open();
                        return;
                    }
                    ConfirmMessageBox cd = new ConfirmMessageBox("Confirm REMOVE", "Are you sure you want to remove the selected common resource(s)?");
                    cd.setHideHandler(new HideHandler(){

                        @Override
                        public void onHide(PreferredButton button) {
                            if (button.getAction() == 2) {
                                ResourcesActions.this.remove(selectionModel.getSelectedSet());
                                selectionModel.clear();
                            }
                        }
                    });
                    cd.open();
                }
            });
            this.add((Widget)removeButton);
        }
    }

    private void addCloneButton() {
        if (ClientPermissions.isAuthorized("resources", "resources:create")) {
            Button cloneButton = new Button("Clone", new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MultiSelectionModel selectionModel = (MultiSelectionModel)ResourcesActions.this.getUnderlyingTable().getTable().getSelectionModel();
                    if (selectionModel.getSelectedSet().isEmpty()) {
                        AlertMessageBox alert = new AlertMessageBox(1, "No resource selected!", "No resource is selected and it's not possible to perform CLONE command.");
                        alert.open();
                        return;
                    }
                    if (selectionModel.getSelectedSet().size() > 1) {
                        AlertMessageBox alert = new AlertMessageBox(1, "Too many resources selected!", "Only one resource can be selected to perform CLONE command.");
                        alert.open();
                        return;
                    }
                    Resource resource = (Resource)selectionModel.getSelectedSet().iterator().next();
                    Resource clone = new Resource();
                    clone.setType(resource.getType());
                    HashMap clonedProperties = (HashMap)resource.getProperties().clone();
                    clone.setProperties(clonedProperties);
                    selectionModel.clear();
                    CloneResourceInspector inspector = new CloneResourceInspector(clone);
                    inspector.center();
                    selectionModel.clear();
                }
            });
            this.add((Widget)cloneButton);
        }
    }

    public void remove(final Collection<Resource> resources) {
        this.getLoading().startProcessing();
        Scheduler scheduler = Scheduler.get();
        scheduler.scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Services.COMMON_RESOURCES_MANAGER.removeCommonResource(resources, (AsyncCallback<Boolean>)new ServiceAsyncCallback<Boolean>(){

                    @Override
                    public void onJemSuccess(Boolean result) {
                        if (ResourcesActions.this.getSearcher() != null) {
                            ResourcesActions.this.getSearcher().refresh();
                        }
                    }

                    @Override
                    public void onJemFailure(Throwable caught) {
                        AlertMessageBox alert = new AlertMessageBox(2, "Remove resources command error!", caught.getMessage());
                        alert.open();
                    }

                    @Override
                    public void onJemExecuted() {
                        ResourcesActions.this.getLoading().stopProcessing();
                    }
                });
            }
        });
    }
}

